/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.autodiscover.AutodiscoverService;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.TraceFlags;
import microsoft.exchange.webservices.data.core.exception.dns.DnsException;
import microsoft.exchange.webservices.data.dns.DnsClient;
import microsoft.exchange.webservices.data.dns.DnsSrvRecord;

class AutodiscoverDnsClient {
    private static final String AutoDiscoverSrvPrefix = "_autodiscover._tcp.";
    private static final int SslPort = 443;
    private static Random RandomTieBreakerSelector = new Random();
    private AutodiscoverService service;

    protected AutodiscoverDnsClient(AutodiscoverService service) {
        this.service = service;
    }

    protected static String extractHostnameFromDnsSrv(String dnsNameTarget) {
        if (dnsNameTarget == null || dnsNameTarget.isEmpty()) {
            return null;
        }
        if (dnsNameTarget.endsWith(".")) {
            dnsNameTarget = dnsNameTarget.substring(0, dnsNameTarget.length() - 1);
        }
        return dnsNameTarget;
    }

    protected String findAutodiscoverHostFromSrv(String domain) throws XMLStreamException, IOException {
        String hostName;
        String domainToMatch = AutoDiscoverSrvPrefix + domain;
        DnsSrvRecord dnsSrvRecord = this.findBestMatchingSrvRecord(domainToMatch);
        if (dnsSrvRecord != null && (hostName = AutodiscoverDnsClient.extractHostnameFromDnsSrv(dnsSrvRecord.getNameTarget())) != null) {
            this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("DNS query for SRV record for domain %s found %s", domain, hostName));
            return hostName;
        }
        this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, "No appropriate SRV record was found.");
        return null;
    }

    private DnsSrvRecord findBestMatchingSrvRecord(String domain) throws XMLStreamException, IOException {
        List<DnsSrvRecord> dnsSrvRecordList;
        try {
            dnsSrvRecordList = DnsClient.dnsQuery(DnsSrvRecord.class, domain, this.service.getDnsServerAddress());
        }
        catch (DnsException ex) {
            String dnsExcMessage = String.format("DnsQuery returned error '%s'.", ex.getMessage());
            this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, dnsExcMessage);
            return null;
        }
        catch (SecurityException ex) {
            this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("DnsQuery cannot be called. Security error: %s.", ex.getMessage()));
            return null;
        }
        this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("%d SRV records were returned.", dnsSrvRecordList.size()));
        int priority = Integer.MIN_VALUE;
        int weight = Integer.MAX_VALUE;
        boolean recordFound = false;
        for (DnsSrvRecord dnsSrvRecord : dnsSrvRecordList) {
            if (dnsSrvRecord.getPort() != 443) continue;
            priority = dnsSrvRecord.getPriority();
            weight = dnsSrvRecord.getWeight();
            recordFound = true;
            break;
        }
        if (!recordFound) {
            this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, "No appropriate SRV records were found.");
            return null;
        }
        ArrayList<DnsSrvRecord> bestDnsSrvRecordList = new ArrayList<DnsSrvRecord>();
        for (DnsSrvRecord dnsSrvRecord : dnsSrvRecordList) {
            if (dnsSrvRecord.getPort() != 443 || dnsSrvRecord.getPriority() != priority || dnsSrvRecord.getWeight() != weight) continue;
            bestDnsSrvRecordList.add(dnsSrvRecord);
        }
        EwsUtilities.ewsAssert(dnsSrvRecordList.size() > 0, "AutodiscoverDnsClient.FindBestMatchingSrvRecord", "At least one DNS SRV record must match the criteria.");
        int recordIndex = bestDnsSrvRecordList.size() > 1 ? RandomTieBreakerSelector.nextInt(bestDnsSrvRecordList.size()) : 0;
        DnsSrvRecord bestDnsSrvRecord = (DnsSrvRecord)bestDnsSrvRecordList.get(recordIndex);
        String traceMessage = String.format("Returning SRV record %d of %d records. Target: %s, Priority: %d, Weight: %d", recordIndex, dnsSrvRecordList.size(), bestDnsSrvRecord.getNameTarget(), bestDnsSrvRecord.getPriority(), bestDnsSrvRecord.getWeight());
        this.service.traceMessage(TraceFlags.AutodiscoverConfiguration, traceMessage);
        return bestDnsSrvRecord;
    }
}

