/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover;

import microsoft.exchange.webservices.data.core.EwsXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;

public final class ProtocolConnection {
    private String encryptionMethod;
    private String hostname;
    private int port;

    protected ProtocolConnection() {
    }

    protected static ProtocolConnection loadFromXml(EwsXmlReader reader) throws Exception {
        ProtocolConnection connection = new ProtocolConnection();
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals("EncryptionMethod")) {
                connection.setEncryptionMethod(reader.readElementValue(String.class));
                continue;
            }
            if (reader.getLocalName().equals("Hostname")) {
                connection.setHostname(reader.readElementValue(String.class));
                continue;
            }
            if (!reader.getLocalName().equals("Port")) continue;
            connection.setPort(reader.readElementValue(Integer.TYPE));
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, "ProtocolConnection"));
        return connection;
    }

    protected ProtocolConnection(String encryptionMethod, String hostname, int port) {
        this.encryptionMethod = encryptionMethod;
        this.hostname = hostname;
        this.port = port;
    }

    public String getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(String value) {
        this.encryptionMethod = value;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String value) {
        this.hostname = value;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        this.port = value;
    }
}

