/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover.exception.error;

import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;

@EditorBrowsable(state=EditorBrowsableState.Never)
public final class AutodiscoverError {
    private String time;
    private String id;
    private int errorCode;
    private String message;
    private String debugData;

    private AutodiscoverError() {
    }

    public static AutodiscoverError parse(EwsXmlReader reader) throws Exception {
        AutodiscoverError error = new AutodiscoverError();
        error.time = reader.readAttributeValue("Time");
        error.id = reader.readAttributeValue("Id");
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equalsIgnoreCase("ErrorCode")) {
                error.errorCode = reader.readElementValue(Integer.class);
                continue;
            }
            if (reader.getLocalName().equalsIgnoreCase("Message")) {
                error.message = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equalsIgnoreCase("DebugData")) {
                error.debugData = reader.readElementValue();
                continue;
            }
            reader.skipCurrentElement();
        } while (!reader.isEndElement(XmlNamespace.NotSpecified, "Error"));
        return error;
    }

    public String getTime() {
        return this.time;
    }

    public String getId() {
        return this.id;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDebugData() {
        return this.debugData;
    }
}

