/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceResult;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.request.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.response.ServiceResponseCollection;
import microsoft.exchange.webservices.data.misc.IAsyncResult;

public abstract class MultiResponseServiceRequest<TResponse extends ServiceResponse>
extends SimpleServiceRequestBase<ServiceResponseCollection<TResponse>> {
    private ServiceErrorHandling errorHandlingMode;

    @Override
    protected ServiceResponseCollection<TResponse> parseResponse(EwsServiceXmlReader reader) throws Exception {
        ServiceResponseCollection<TResponse> serviceResponses = new ServiceResponseCollection<TResponse>();
        reader.readStartElement(XmlNamespace.Messages, "ResponseMessages");
        for (int i = 0; i < this.getExpectedResponseMessageCount(); ++i) {
            reader.read();
            if (reader.isEndElement(XmlNamespace.Messages, "ResponseMessages")) break;
            TResponse response = this.createServiceResponse(reader.getService(), i);
            ((ServiceResponse)response).loadFromXml(reader, this.getResponseMessageXmlElementName());
            serviceResponses.add(response);
        }
        if (serviceResponses.getCount() < this.getExpectedResponseMessageCount()) {
            if (serviceResponses.getCount() == 1 && ((ServiceResponse)serviceResponses.getResponseAtIndex(0)).getResult() == ServiceResult.Error) {
                throw new ServiceResponseException((ServiceResponse)serviceResponses.getResponseAtIndex(0));
            }
            throw new ServiceXmlDeserializationException(String.format("The service was expected to return %s response of type '%d', but %d response were received.", this.getResponseMessageXmlElementName(), this.getExpectedResponseMessageCount(), serviceResponses.getCount()));
        }
        reader.readEndElementIfNecessary(XmlNamespace.Messages, "ResponseMessages");
        return serviceResponses;
    }

    protected abstract TResponse createServiceResponse(ExchangeService var1, int var2) throws Exception;

    protected abstract String getResponseMessageXmlElementName();

    protected abstract int getExpectedResponseMessageCount();

    protected MultiResponseServiceRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service);
        this.errorHandlingMode = errorHandlingMode;
    }

    public ServiceResponseCollection<TResponse> execute() throws Exception {
        ServiceResponseCollection serviceResponses = (ServiceResponseCollection)this.internalExecute();
        if (this.errorHandlingMode == ServiceErrorHandling.ThrowOnError) {
            EwsUtilities.ewsAssert(serviceResponses.getCount() == 1, "MultiResponseServiceRequest.Execute", "ServiceErrorHandling.ThrowOnError error handling is only valid for singleton request");
            ((ServiceResponse)serviceResponses.getResponseAtIndex(0)).throwIfNecessary();
        }
        return serviceResponses;
    }

    public ServiceResponseCollection<TResponse> endExecute(IAsyncResult asyncResult) throws Exception {
        ServiceResponseCollection serviceResponses = (ServiceResponseCollection)this.endInternalExecute(asyncResult);
        if (this.errorHandlingMode == ServiceErrorHandling.ThrowOnError) {
            EwsUtilities.ewsAssert(serviceResponses.getCount() == 1, "MultiResponseServiceRequest.Execute", "ServiceErrorHandling.ThrowOnError error handling is only valid for singleton request");
            ((ServiceResponse)serviceResponses.getResponseAtIndex(0)).throwIfNecessary();
        }
        return serviceResponses;
    }

    protected ServiceErrorHandling getErrorHandlingMode() {
        return this.errorHandlingMode;
    }
}

