/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.response;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.misc.error.ServiceError;
import microsoft.exchange.webservices.data.core.response.DelegateUserResponse;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.property.complex.DelegateUser;

public class DelegateManagementResponse
extends ServiceResponse {
    private boolean readDelegateUsers;
    private List<DelegateUser> delegateUsers;
    private Collection<DelegateUserResponse> delegateUserResponses;

    public DelegateManagementResponse(boolean readDelegateUsers, List<DelegateUser> delegateUsers) {
        this.readDelegateUsers = readDelegateUsers;
        this.delegateUsers = delegateUsers;
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws Exception {
        if (this.getErrorCode() == ServiceError.NoError) {
            this.delegateUserResponses = new ArrayList<DelegateUserResponse>();
            reader.read();
            if (reader.isStartElement(XmlNamespace.Messages, "ResponseMessages")) {
                int delegateUserIndex = 0;
                do {
                    reader.read();
                    if (!reader.isStartElement(XmlNamespace.Messages, "DelegateUserResponseMessageType")) continue;
                    DelegateUser delegateUser = null;
                    if (this.readDelegateUsers && this.delegateUsers != null) {
                        delegateUser = this.delegateUsers.get(delegateUserIndex);
                    }
                    DelegateUserResponse delegateUserResponse = new DelegateUserResponse(this.readDelegateUsers, delegateUser);
                    delegateUserResponse.loadFromXml(reader, "DelegateUserResponseMessageType");
                    this.delegateUserResponses.add(delegateUserResponse);
                    ++delegateUserIndex;
                } while (!reader.isEndElement(XmlNamespace.Messages, "ResponseMessages"));
            }
        }
    }

    public Collection<DelegateUserResponse> getDelegateUserResponses() {
        return this.delegateUserResponses;
    }
}

