/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.misc.AbstractFolderIdWrapper;
import microsoft.exchange.webservices.data.misc.FolderIdWrapper;
import microsoft.exchange.webservices.data.misc.FolderWrapper;
import microsoft.exchange.webservices.data.property.complex.FolderId;

public class FolderIdWrapperList
implements Iterable<AbstractFolderIdWrapper> {
    private List<AbstractFolderIdWrapper> ids = new ArrayList<AbstractFolderIdWrapper>();

    public void add(Folder folder) throws ServiceLocalException {
        this.ids.add(new FolderWrapper(folder));
    }

    protected void addRangeFolder(Iterable<Folder> folders) throws ServiceLocalException {
        if (folders != null) {
            for (Folder folder : folders) {
                this.add(folder);
            }
        }
    }

    public void add(FolderId folderId) {
        this.ids.add(new FolderIdWrapper(folderId));
    }

    public void addRangeFolderId(Iterable<FolderId> folderIds) {
        if (folderIds != null) {
            for (FolderId folderId : folderIds) {
                this.add(folderId);
            }
        }
    }

    public void writeToXml(EwsServiceXmlWriter writer, XmlNamespace ewsNamesapce, String xmlElementName) throws Exception {
        if (this.getCount() > 0) {
            writer.writeStartElement(ewsNamesapce, xmlElementName);
            for (AbstractFolderIdWrapper folderIdWrapper : this.ids) {
                folderIdWrapper.writeToXml(writer);
            }
            writer.writeEndElement();
        }
    }

    public int getCount() {
        return this.ids.size();
    }

    public AbstractFolderIdWrapper getFolderIdWrapperList(int i) {
        return this.ids.get(i);
    }

    public void validate(ExchangeVersion version) throws ServiceVersionException {
        for (AbstractFolderIdWrapper folderIdWrapper : this.ids) {
            folderIdWrapper.validate(version);
        }
    }

    @Override
    public Iterator<AbstractFolderIdWrapper> iterator() {
        return this.ids.iterator();
    }
}

