/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.service.item.Contact;
import microsoft.exchange.webservices.data.misc.NameResolutionCollection;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;

public final class NameResolution {
    private NameResolutionCollection owner;
    private EmailAddress mailbox = new EmailAddress();
    private Contact contact;

    protected NameResolution(NameResolutionCollection owner) {
        EwsUtilities.ewsAssert(owner != null, "NameResolution.ctor", "owner is null.");
        this.owner = owner;
    }

    protected void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Types, "Resolution");
        reader.readStartElement(XmlNamespace.Types, "Mailbox");
        this.mailbox.loadFromXml(reader, "Mailbox");
        reader.read();
        if (reader.isStartElement(XmlNamespace.Types, "Contact")) {
            this.contact = new Contact(this.owner.getSession());
            this.contact.loadFromXml(reader, true, PropertySet.FirstClassProperties, false);
            reader.readEndElement(XmlNamespace.Types, "Resolution");
        } else {
            reader.ensureCurrentNodeIsEndElement(XmlNamespace.Types, "Resolution");
        }
    }

    public EmailAddress getMailbox() {
        return this.mailbox;
    }

    public Contact getContact() {
        return this.contact;
    }
}

