/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc.availability;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;

public final class OofReply {
    private String culture = "en-US";
    private String message;

    public static void writeEmptyReplyToXml(EwsServiceXmlWriter writer, String xmlElementName) throws XMLStreamException {
        writer.writeStartElement(XmlNamespace.Types, xmlElementName);
        writer.writeEndElement();
    }

    public OofReply() {
    }

    public OofReply(String message) {
        this.message = message;
    }

    public static OofReply getOofReplyFromString(String message) {
        return new OofReply(message);
    }

    public static String getStringFromOofReply(OofReply oofReply) throws Exception {
        EwsUtilities.validateParam(oofReply, "oofReply");
        return oofReply.message;
    }

    public void loadFromXml(EwsServiceXmlReader reader, String xmlElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, xmlElementName);
        if (reader.hasAttributes()) {
            this.setCulture(reader.readAttributeValue("xml:lang"));
        }
        this.message = reader.readElementValue(XmlNamespace.Types, "Message");
        reader.readEndElement(XmlNamespace.Types, xmlElementName);
    }

    public void writeToXml(EwsServiceXmlWriter writer, String xmlElementName) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, xmlElementName);
        if (this.culture != null) {
            writer.writeAttributeValue("xml", "lang", (Object)this.culture);
        }
        writer.writeElementValue(XmlNamespace.Types, "Message", this.message);
        writer.writeEndElement();
    }

    public String toString() {
        return this.message;
    }

    public String getCulture() {
        return this.culture;
    }

    public void setCulture(String culture) {
        this.culture = culture;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

