/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.notification;

import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.misc.AsyncCallback;
import microsoft.exchange.webservices.data.misc.IAsyncResult;
import microsoft.exchange.webservices.data.notification.GetEventsResults;
import microsoft.exchange.webservices.data.notification.SubscriptionBase;

public final class PullSubscription
extends SubscriptionBase {
    private boolean moreEventsAvailable;

    public PullSubscription(ExchangeService service) throws Exception {
        super(service);
    }

    public GetEventsResults getEvents() throws Exception {
        GetEventsResults results = this.getService().getEvents(this.getId(), this.getWaterMark());
        this.setWaterMark(results.getNewWatermark());
        this.moreEventsAvailable = results.isMoreEventsAvailable();
        return results;
    }

    public IAsyncResult beginGetEvents(AsyncCallback callback, Object state) throws Exception {
        return this.getService().beginGetEvents(callback, state, this.getId(), this.getWaterMark());
    }

    public GetEventsResults endGetEvents(IAsyncResult asyncResult) throws Exception {
        GetEventsResults results = this.getService().endGetEvents(asyncResult);
        this.setWaterMark(results.getNewWatermark());
        this.moreEventsAvailable = results.isMoreEventsAvailable();
        return results;
    }

    public void unsubscribe() throws Exception {
        this.getService().unsubscribe(this.getId());
    }

    public IAsyncResult beginUnsubscribe(AsyncCallback callback, Object state) throws Exception {
        return this.getService().beginUnsubscribe(callback, state, this.getId());
    }

    public void endUnsubscribe(IAsyncResult asyncResult) throws Exception {
        this.getService().endUnsubscribe(asyncResult);
    }

    public boolean isMoreEventsAvailable() {
        return this.moreEventsAvailable;
    }
}

