/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.property.complex.ComplexPropertyCollection;
import microsoft.exchange.webservices.data.property.complex.FolderId;

@EditorBrowsable(state=EditorBrowsableState.Never)
public final class FolderIdCollection
extends ComplexPropertyCollection<FolderId> {
    protected FolderIdCollection() {
    }

    @Override
    protected FolderId createComplexProperty(String xmlElementName) {
        return new FolderId();
    }

    public void add(FolderId folderId) throws Exception {
        EwsUtilities.validateParam(folderId, "folderId");
        if (this.contains(folderId)) {
            throw new IllegalArgumentException("The ID is already in the list.");
        }
        this.internalAdd(folderId);
    }

    @Override
    protected String getCollectionItemXmlElementName(FolderId complexProperty) {
        return complexProperty.getXmlElementName();
    }

    public FolderId add(WellKnownFolderName folderName) {
        FolderId folderId = new FolderId(folderName);
        if (this.contains(folderId)) {
            throw new IllegalArgumentException("The ID is already in the list.");
        }
        this.internalAdd(folderId);
        return folderId;
    }

    public void clear() {
        this.internalClear();
    }

    public void removeAt(int index) {
        if (index < 0 || index >= this.getCount()) {
            throw new IndexOutOfBoundsException("index is out of range.");
        }
        this.internalRemoveAt(index);
    }

    public boolean remove(FolderId folderId) throws Exception {
        EwsUtilities.validateParam(folderId, "folderId");
        return this.internalRemove(folderId);
    }

    public boolean remove(WellKnownFolderName folderName) {
        FolderId folderId = FolderId.getFolderIdFromWellKnownFolderName(folderName);
        return this.internalRemove(folderId);
    }
}

