/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core;

import de.wilke.wizepanel.core.WpUtils;
import java.io.IOException;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public class PrettyPrinter {
    public static String block(Map<String, Object> map) {
        return PrettyPrinter.block(map, '.');
    }

    public static String block(Map<String, Object> map, char c) {
        int n = 0;
        for (String object : map.keySet()) {
            if (object.length() <= n) continue;
            n = object.length();
        }
        n += 2;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : map.keySet()) {
            stringBuilder.append(string);
            for (int i = 0; i < n - string.length(); ++i) {
                stringBuilder.append(c);
            }
            stringBuilder.append(": ");
            stringBuilder.append(map.get(string));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String condensed(Map<String, Object> map) {
        LinkedList<CallSite> linkedList = new LinkedList<CallSite>();
        for (String string : map.keySet()) {
            linkedList.add((CallSite)((Object)(string + ": " + map.get(string))));
        }
        return WpUtils.implode(", ", linkedList);
    }

    public static String stripHTML(String string) {
        final StringBuffer stringBuffer = new StringBuffer();
        ParserDelegator parserDelegator = new ParserDelegator();
        HTMLEditorKit.ParserCallback parserCallback = new HTMLEditorKit.ParserCallback(){

            @Override
            public void handleText(char[] cArray, int n) {
                stringBuffer.append(new String(cArray));
            }

            @Override
            public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            }

            @Override
            public void handleEndTag(HTML.Tag tag, int n) {
            }

            @Override
            public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
                if (tag.equals(HTML.Tag.BR)) {
                    stringBuffer.append(new String(" "));
                }
            }

            @Override
            public void handleComment(char[] cArray, int n) {
            }

            @Override
            public void handleError(String string, int n) {
            }
        };
        try {
            parserDelegator.parse(new StringReader(string), parserCallback, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

