/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core;

import de.wilke.wizepanel.core.locator.WpSystemLocator;
import java.util.HashMap;
import java.util.Map;

public class WizePanelExceptions
extends Exception {
    private static final long serialVersionUID = 8481309663462479772L;
    public static final int WP_ERROR_CODE_VALUE_UNDEFINED = -1;
    public static final String WP_ERROR_DESCRIPTION_UNDEFINED = "undefined";
    public static final String WP_ERROR_PREFIX_CODE_SEP = ".";
    public static final String WP_ERROR_NAME_PREFIX = "wperror";
    private static String errorDescrLanguage = WpSystemLocator.getLocator().getDefaultLanguage();
    private static String activeApplicationName = "wperror";
    public static final Map<Integer, ErrorCodes> ErrorHardwareNameNumMap = new HashMap<Integer, ErrorCodes>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, ErrorCodes.WP_COMM_UNKNOWN_ERROR_CODE);
            this.put(1, ErrorCodes.WP_COMM_ERROR_ID_NO_SUCH_CMD);
            this.put(2, ErrorCodes.WP_COMM_ERROR_ID_WRONG_ACTION_CODE);
            this.put(3, ErrorCodes.WP_COMM_ERROR_ID_TOO_LESS_PARAMS);
            this.put(4, ErrorCodes.WP_COMM_ERROR_ID_TOO_MUCH_PARAMS);
            this.put(5, ErrorCodes.WP_COMM_ERROR_ID_INTERNAL_WRITE_ERROR);
            this.put(6, ErrorCodes.WP_COMM_ERROR_ID_INTERNAL_READ_ERROR);
            this.put(8, ErrorCodes.WP_COMM_ERROR_ID_WRONG_PACKET_NUMBER);
            this.put(9, ErrorCodes.WP_COMM_ERROR_ID_PARAM1_OUT_OF_RANGE);
            this.put(10, ErrorCodes.WP_COMM_ERROR_ID_PARAM2_OUT_OF_RANGE);
            this.put(11, ErrorCodes.WP_COMM_ERROR_ID_PARAM3_OUT_OF_RANGE);
            this.put(12, ErrorCodes.WP_COMM_ERROR_ID_PARAM4_OUT_OF_RANGE);
            this.put(13, ErrorCodes.WP_COMM_ERROR_ID_PARAM5_OUT_OF_RANGE);
            this.put(14, ErrorCodes.WP_COMM_ERROR_ID_TOO_MUCH_DATA);
            this.put(15, ErrorCodes.WP_COMM_ERROR_ID_NO_SPACE_LEFT);
            this.put(16, ErrorCodes.WP_COMM_ERROR_ID_ADDRESS_RANGE_EXEEDED);
            this.put(19, ErrorCodes.WP_COMM_ERROR_ID_WRONG_CRC);
            this.put(20, ErrorCodes.WP_COMM_ERROR_ID_PIC_IS_COMPRESSED);
            this.put(21, ErrorCodes.WP_COMM_ERROR_ID_LCD_ERROR);
            this.put(22, ErrorCodes.WP_COMM_ERROR_ID_DATA_LENGTH_ERROR);
            this.put(23, ErrorCodes.WP_COMM_ERROR_ID_WRONG_TIME_FORMAT);
            this.put(24, ErrorCodes.WP_COMM_ERROR_ID_INCOMPLETE_PACKET);
            this.put(26, ErrorCodes.WP_COMM_ERROR_ID_INCOMPLETE_BMP);
            this.put(27, ErrorCodes.WP_COMM_ERROR_ID_NO_BMP_FILE);
            this.put(28, ErrorCodes.WP_COMM_ERROR_ID_NO_BLACKWHITE_BMP);
            this.put(29, ErrorCodes.WP_COMM_ERROR_ID_INVALID_IMAGE_SIZE);
            this.put(30, ErrorCodes.WP_COMM_ERROR_ID_RTC_ERROR);
            this.put(31, ErrorCodes.WP_COMM_ERROR_ID_FILTER_LIST_NOT_SET);
            this.put(32, ErrorCodes.WP_COMM_ERROR_ID_UNKNOWN_HEADER_TYPE);
            this.put(36, ErrorCodes.WP_COMM_ERROR_ID_NOT_ENOUGH_FLASH_FOR_NEW_FIRMWARE);
            this.put(42, ErrorCodes.WP_COMM_ERROR_ID_MAXIMUM_NUMBER_OF_REGISTERED_PANELS_EXCEEDED);
            this.put(63, ErrorCodes.WP_COMM_ERROR_ID_FATAL_FIRMWARE);
            this.put(69, ErrorCodes.WP_COMM_ERROR_ID_TARGET_DOES_NOT_RESPONSE_ANY_MORE);
            this.put(73, ErrorCodes.WP_COMM_ERROR_ID_TRANS_NOT_FOUND);
            this.put(241, ErrorCodes.WP_COMM_ERROR_ID_NO_SUCH_CMD);
        }
    };
    private ErrorCodes errorCode;
    private String errorParams;

    public WizePanelExceptions() {
        this.errorCode = null;
        this.errorParams = "";
    }

    public WizePanelExceptions(ErrorCodes errorCodes) {
        this.errorCode = errorCodes;
        this.errorParams = "";
    }

    public WizePanelExceptions(ErrorCodes errorCodes, String string) {
        this.errorCode = errorCodes;
        this.errorParams = string;
    }

    public ErrorCodes getErrorCode() {
        return this.errorCode;
    }

    public String getErrorParams() {
        return this.errorParams;
    }

    public String getErrorName() {
        if (this.errorCode != null) {
            return this.errorCode.errorName;
        }
        return WP_ERROR_DESCRIPTION_UNDEFINED;
    }

    public String getErrorDescription() {
        if (this.errorCode != null) {
            String string = null;
            string = WizePanelExceptions.getErrorDescrText(this.errorCode.errorName, this.errorParams);
            if (string != null) {
                return string;
            }
            return this.errorCode.errorName;
        }
        return WP_ERROR_DESCRIPTION_UNDEFINED;
    }

    @Override
    public String getMessage() {
        return this.getErrorDescription();
    }

    public static ErrorCodes getErrorCodes(String string) {
        for (ErrorCodes errorCodes : ErrorCodes.values()) {
            if (!errorCodes.errorName.equals(string)) continue;
            return errorCodes;
        }
        return null;
    }

    public static String getErrorDescription(ErrorCodes errorCodes, String string) {
        if (errorCodes != null) {
            return WizePanelExceptions.getErrorDescription(errorCodes.errorName, string);
        }
        return WP_ERROR_DESCRIPTION_UNDEFINED;
    }

    public static String getErrorDescription(String string, String string2) {
        String string3 = null;
        string3 = WizePanelExceptions.getErrorDescrText(string, string2);
        if (string3 != null) {
            return string3;
        }
        return string;
    }

    public static ErrorCodes getHardwareErrorCodesNameByNum(int n) {
        ErrorCodes errorCodes = ErrorHardwareNameNumMap.get(n);
        if (errorCodes == null) {
            return ErrorCodes.WP_COMM_UNKNOWN_ERROR_CODE;
        }
        return errorCodes;
    }

    public static int getHardwareErrorNumByErrorCodesName(ErrorCodes errorCodes) {
        for (Map.Entry<Integer, ErrorCodes> entry : ErrorHardwareNameNumMap.entrySet()) {
            if (!entry.getValue().equals((Object)errorCodes)) continue;
            return entry.getKey();
        }
        return 0;
    }

    public static String getErrorDescrLanguage() {
        return errorDescrLanguage;
    }

    public static void setErrorDescrLanguage(String string) {
        errorDescrLanguage = string;
    }

    public static String getActiveApplicationName() {
        return activeApplicationName;
    }

    public static void setActiveApplicationName(String string) {
        activeApplicationName = string;
    }

    private static String buildErrorName(String string) {
        return "wperror." + string;
    }

    private static String getErrorDescrText(String string, String string2) {
        return WizePanelExceptions.getErrorDescrText(activeApplicationName, errorDescrLanguage, string, string2);
    }

    private static String getErrorDescrText(String string, String string2, String string3, String string4) {
        return WizePanelExceptions.buildErrorName(string3) + (String)(string4 == null || string4.isEmpty() ? "" : " [" + string4 + "]");
    }

    public static enum ErrorCodes {
        WP_SERV_NO_ROUTER("serv.router_not_found"),
        WP_SERV_UNKNOWN_METHOD("serv.unknown_method"),
        WP_SERV_NO_TARGET("serv.target_not_found"),
        WP_SERV_TARGET_NOT_KNOWN_BY_DISPATCHER("serv.target_not_known_by_dispatcher"),
        WP_SERV_NO_ROUTING_DESCRIPTION("serv.routing_description_not_generated"),
        WP_SERV_INVALID_DATA("serv.invalid_data"),
        WP_SERV_DATA_TOOBIG("serv.data_too_big"),
        WP_SERV_TOO_MANY_OPEN_JOBS("serv.too_many_open_jobs"),
        WP_SERV_DUPLICATE("serv.duplicate"),
        WP_SERV_LICENSE_VIOLATION_TOO_MANY_TARGETS("serv.license_violation.too_many_targets"),
        WP_COMM_UNKNOWN_ERROR_CODE("prop.comm.unknown_error_code"),
        WP_COMM_ERROR_ID_NO_SUCH_CMD("prot.comm.no_such_cmd", true, false),
        WP_COMM_ERROR_ID_WRONG_ACTION_CODE("prot.comm.wrong_action_code"),
        WP_COMM_ERROR_ID_TOO_LESS_PARAMS("prot.comm.too_less_params"),
        WP_COMM_ERROR_ID_TOO_MUCH_PARAMS("prot.comm.too_much_params"),
        WP_COMM_ERROR_ID_INTERNAL_WRITE_ERROR("prot.comm.internal_write_error", true),
        WP_COMM_ERROR_ID_INTERNAL_READ_ERROR("prot.comm.internal_read_error"),
        WP_COMM_ERROR_ID_WRONG_PACKET_NUMBER("prot.comm.wrong_packet_number"),
        WP_COMM_ERROR_ID_PARAM1_OUT_OF_RANGE("prot.comm.param1_out_of_range"),
        WP_COMM_ERROR_ID_PARAM2_OUT_OF_RANGE("prot.comm.param2_out_of_range"),
        WP_COMM_ERROR_ID_PARAM3_OUT_OF_RANGE("prot.comm.param3_out_of_range"),
        WP_COMM_ERROR_ID_PARAM4_OUT_OF_RANGE("prot.comm.param4_out_of_range"),
        WP_COMM_ERROR_ID_PARAM5_OUT_OF_RANGE("prot.comm.param5_out_of_range"),
        WP_COMM_ERROR_ID_TOO_MUCH_DATA("prot.comm.too_much_data"),
        WP_COMM_ERROR_ID_NO_SPACE_LEFT("prot.comm.no_space_left", true),
        WP_COMM_ERROR_ID_ADDRESS_RANGE_EXEEDED("prot.comm.address_range_exeeded"),
        WP_COMM_ERROR_ID_WRONG_CRC("prot.comm.wrong_crc"),
        WP_COMM_ERROR_ID_PIC_IS_COMPRESSED("prot.comm.pic_is_compressed"),
        WP_COMM_ERROR_ID_LCD_ERROR("prot.comm.lcd_error"),
        WP_COMM_ERROR_ID_DATA_LENGTH_ERROR("prot.comm.data_length_error"),
        WP_COMM_ERROR_ID_WRONG_TIME_FORMAT("prot.comm.wrong_time_format"),
        WP_COMM_ERROR_ID_INCOMPLETE_PACKET("prot.comm.incomplete_packet"),
        WP_COMM_ERROR_ID_INCOMPLETE_BMP("prot.comm.incomplete_bmp", true, false),
        WP_COMM_ERROR_ID_NO_BMP_FILE("prot.comm.no_bmp_file", true, false),
        WP_COMM_ERROR_ID_NO_IMAGE_FILE("prot.comm.no_image_file", true, false),
        WP_COMM_ERROR_ID_NO_BLACKWHITE_BMP("prot.comm.no_blackwhite_bmp", true, false),
        WP_COMM_ERROR_ID_INVALID_IMAGE_SIZE("prot.comm.invalid_image_size", true, false),
        WP_COMM_ERROR_ID_RTC_ERROR("prot.comm.rtc_error"),
        WP_COMM_ERROR_ID_FILTER_LIST_NOT_SET("prot.comm.filter_list_not_set", true),
        WP_COMM_ERROR_ID_UNKNOWN_HEADER_TYPE("prot.comm.unknown_header_type"),
        WP_COMM_ERROR_ID_NOT_ENOUGH_FLASH_FOR_NEW_FIRMWARE("prot.comm.not_enough_flash_for_new_firmware", true, false),
        WP_COMM_ERROR_ID_MAXIMUM_NUMBER_OF_REGISTERED_PANELS_EXCEEDED("prot.comm.maximum_number_of_registered_panels_exceeded", true),
        WP_COMM_ERROR_ID_FATAL_FIRMWARE("prot.comm.fatal_firmware", true),
        WP_COMM_ERROR_ID_TARGET_DOES_NOT_RESPONSE_ANY_MORE("prot.comm.target_does_not_response_any_more"),
        WP_COMM_ERROR_ID_TRANS_NOT_FOUND("prot.comm.trans_not_found", true),
        WP_DATA_ERROR_ID_TOO_MANY_ERRORS("prop.comm.too_many_errors"),
        WP_DATA_ERROR_ID_INCORRECT_IP_FORM("prot.data.incorrect_ip_form", true, false),
        WP_DATA_ERROR_ID_INVALID_PORT_NUMBER("prot.data.invalid_port_number", true, false),
        WP_DATA_ERROR_ID_CORRUPTED_PACKET("prot.data.corrupted_packet"),
        WP_DATA_ERROR_ID_SEND_TO_CLOSED_SOCKET("prot.data.send_to_closed_socket"),
        WP_DATA_ERROR_ID_NO_RESPONSE("prot.data.no_response"),
        WP_DATA_ERROR_ID_CORRUPTED_RESPONSE_PACKET("prot.data.corrupted_response_packet"),
        WP_FWD_IO_ERROR_ID_UNKNOWN_HOST_EXCEPTION("prot.fwdio.unknown_host_exception"),
        WP_FWD_IO_ERROR_ID_IO_EXCEPTION("prot.fwdio.io_exception"),
        WP_FWD_IO_ERROR_ID_SOCKET_EXCEPTION("prot.fwdio.socket_exception"),
        WP_FWD_IO_ERROR_ID_FILE_NOT_FOUND_EXCEPTION("prot.fwdio.file_not_found_exception"),
        WP_FWD_IO_ERROR_ID_ILLEGAL_ARGUMENT_EXCEPTION("prot.fwdio.illegal_argument_exception"),
        WP_FWD_IO_ERROR_ID_INPUT_STREAM_CLOSE_FAILED("prot.fwdio.input_stream_close_failed"),
        WP_FWD_IO_ERROR_ID_FAILED_TO_READ_PROP_INPUT_STREAM("prot.fwdio.failed_to_read_prop_input_stream"),
        WP_FWD_IO_ERROR_ID_UNABLE_TO_SET_SO_TIMEOUT("prot.fwdio.unable_to_set_so_timeout"),
        WP_FWD_IO_ERROR_ID_TIMEOUT_OCCURRED_KILLING_CONNECTION("prot.fwdio.timeout_occured_killing_connection"),
        WP_ARGS_ERROR_ID_NOT_INITIALIZED("prot.args.not_initialized"),
        WP_ARGS_ERROR_ID_INVALID_COMMAND("prot.args.invalid_command"),
        WP_ARGS_ERROR_ID_NO_ARGS("prot.args.no_args"),
        WP_ARGS_TOO_MANY_PACKETS("prot.args.to_many_packets", true, false),
        WP_PROT_ERROR_ID_INIT_FAILED("prot.appl.init_failed"),
        WP_EM_INVALID_ICS("em.open.invalid_ics"),
        WP_EM_NO_VEVENT("em.open.no_vevent"),
        WP_EM_TOO_MANY_EVENTS("em.open.too_many_vevents"),
        WP_EM_TARGET_UNRESOLVED("em.open.target_unresolved"),
        WP_EM_UNKNOWN_DISPATCHER("em.open.unknown.dispatcher"),
        WP_EM_WAKEUP_UNRESOLVED("em.open.wakeup_unresolved"),
        WP_EM_EXPIRED_EVENT("em.open.event_expired"),
        WP_EM_EVENT_NOT_CHANGED("em.open.event_not_changed"),
        WP_EM_NO_RULE_FOUND("em.send.no_rule_found"),
        WP_EM_FILENOTFOUND("em.filenotfound"),
        WP_EM_SECURITYEXCEPTION("em.securityexception");

        private final String errorName;
        private final boolean is_fatal;
        private final boolean do_resend;

        private ErrorCodes(String string2, boolean bl) {
            this.errorName = string2;
            this.is_fatal = bl;
            this.do_resend = true;
        }

        private ErrorCodes(String string2, boolean bl, boolean bl2) {
            this.errorName = string2;
            this.is_fatal = bl;
            this.do_resend = bl2;
        }

        private ErrorCodes(String string2) {
            this.errorName = string2;
            this.is_fatal = false;
            this.do_resend = true;
        }

        public boolean isFatal() {
            return this.is_fatal;
        }

        public boolean doResend() {
            return this.do_resend;
        }

        public String toString() {
            return this.name();
        }
    }
}

