/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core;

import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class WpFile {
    private String originalFileName;
    private String resolvedFileName;
    private File javaFile;
    private WpFileType originalFileType;
    private String fileTypePropVarString = "";

    public WpFile(String string) {
        this.originalFileName = string;
        this.resolvedFileName = this.resolveFileName(this.originalFileName);
        this.javaFile = new File(this.resolvedFileName);
    }

    public WpFile(String string, WpFileType wpFileType) {
        this.originalFileType = wpFileType;
        string = WpFileUtils.expandPathPlaceholders(string);
        File file = new File(string);
        if (file.isAbsolute()) {
            this.originalFileName = string;
            this.resolvedFileName = this.resolveFileName(this.originalFileName);
            this.javaFile = new File(this.resolvedFileName);
        } else {
            this.fileTypePropVarString = "${wp_prop:" + wpFileType.propName + "}";
            this.originalFileName = this.fileTypePropVarString + (String)(string != null && !string.isEmpty() ? "/" + string : "");
            this.resolvedFileName = this.resolveFileName(this.originalFileName);
            this.javaFile = new File(this.resolvedFileName);
        }
    }

    public WpFile(WpFileType wpFileType) {
        this("", wpFileType);
    }

    public boolean exists() {
        return this.javaFile.exists();
    }

    public boolean isDirectory() {
        return this.javaFile.isDirectory();
    }

    public boolean isFile() {
        return this.javaFile.isFile();
    }

    public String[] list() {
        return this.javaFile.list();
    }

    public boolean delete() {
        return this.javaFile.delete();
    }

    public String[] list(final String string) {
        return this.javaFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return string2.endsWith(string);
            }
        });
    }

    private String resolveFileName(String string) {
        try {
            return WpFileUtils.getAbsoluteFileExt(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return WpFileUtils.getAbsoluteFileExt(string).getAbsolutePath();
        }
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public String getResolvedFileName() {
        return this.resolvedFileName;
    }

    public WpFileType getOriginalFileType() {
        return this.originalFileType;
    }

    public File getJavaFile() {
        return this.javaFile;
    }

    public static enum WpFileType {
        TEMPLATE_FILE(WpSystemLocator.WpSystemLocatorPropType.TEMPLATES_DIR.getName()),
        LANGUAGE_FILE(WpSystemLocator.WpSystemLocatorPropType.LANGUAGES_DIR.getName()),
        IMAGE_FILE(WpSystemLocator.WpSystemLocatorPropType.IMAGES_DIR.getName()),
        CURSOR_FILE(WpSystemLocator.WpSystemLocatorPropType.CURSORS_DIR.getName()),
        FACTORY_IMAGE_FILE(WpSystemLocator.WpSystemLocatorPropType.FACTORY_IMAGES_DIR.getName()),
        EVENT_FILE(WpSystemLocator.WpSystemLocatorPropType.EVENTS_DIR.getName()),
        EVENT_SPOOL_FILE(WpSystemLocator.WpSystemLocatorPropType.EVENTS_SPOOL_DIR.getName()),
        RESOURCE_WATCH_FILE(WpSystemLocator.WpSystemLocatorPropType.RESOURCES_WATCH_DIR.getName()),
        RESOURCE_CSV_WATCH_FILE(WpSystemLocator.WpSystemLocatorPropType.RESOURCES_CSV_WATCH_DIR.getName()),
        COMMAND_WATCH_FILE(WpSystemLocator.WpSystemLocatorPropType.COMMANDS_WATCH_DIR.getName()),
        COMMAND_WATCH_RESPONSE_FILE(WpSystemLocator.WpSystemLocatorPropType.COMMANDS_WATCH_RESPONSE_DIR.getName()),
        RESOURCE_FILE(WpSystemLocator.WpSystemLocatorPropType.RESOURCES_DIR.getName()),
        FINAL_RESOURCE_FILE(WpSystemLocator.WpSystemLocatorPropType.FINAL_RESOURCES_DIR.getName()),
        FINAL_IMG_RESOURCE_FILE(WpSystemLocator.WpSystemLocatorPropType.FINAL_IMG_RESOURCES_DIR.getName()),
        FINAL_IMG_SMALL_RESOURCE_FILE(WpSystemLocator.WpSystemLocatorPropType.FINAL_IMG_SMALL_RESOURCES_DIR.getName());

        private final String propName;

        private WpFileType(String string2) {
            this.propName = string2;
        }
    }
}

