/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core;

import java.awt.Color;
import java.awt.Font;

public class WpTemplateUtils {
    public static final String ICS_DTSTART = "DTSTART";
    public static final String ICS_DTEND = "DTEND";
    public static final String ICS_SUMMARY = "SUMMARY";
    public static final String ICS_DESCRIPTION = "DESCRIPTION";
    public static final String ICS_LOCATION = "LOCATION";
    public static final String ICS_UID = "UID";
    public static final String ICS_CREATOR = "CREATOR";
    public static final String ICS_EVENT_QR = "EVENT_QR";
    public static final String ICS_TIMETABLE_WEEK = "TIMETABLE_WEEK";
    public static final String ICS_TIMETABLE_DAY = "TIMETABLE_DAY";
    public static final String TIMETABLE_CURRENT_DAY = "CURRENT_DAY";
    public static final String TIMETABLE_EVENTLIST = "EVENTLIST";
    public static final String TARGET_ID = "TARGET_ID";
    public static final String TARGET_NAME = "TARGET_NAME";
    public static final String TARGET_COMMENT = "TARGET_COMMENT";
    public static final String FREE_UNTIL = "FREE_UNTIL";
    public static final String TODAY = "TODAY";
    public static final String NOW = "NOW";
    public static final String DATETIME = "DATETIME";
    public static final String SOURCE = "SOURCE";
    public static final String TEMPLATE = "TEMPLATE";
    public static final String TEMPLATE_BLANK = "blank";
    public static final String TEMPLATE_MANY = "many";
    private static final String[] m_placeholders = new String[]{"", "DTSTART[0]", "DTEND[0]", "DATETIME[0]", "SUMMARY[0]", "DESCRIPTION[0]", "LOCATION[0]", "UID[0]", "CREATOR[0]", "EVENT_QR[0]", "TIMETABLE_DAY[0]", "TIMETABLE_WEEK[0]", "TARGET_NAME", "TARGET_COMMENT", "FREE_UNTIL", "TODAY", "SOURCE"};
    private static final String[] m_date_formats = new String[]{"", "{date:HH:mm}", "{date:dd.MM.yyyy}", "{date:dd.MM.}", "{date:d.M.}", "{date:dd.MM.yyyy HH:mm}", "{date:dd.MM. HH:mm}", "{date:d.M.yy}", "{date:d.M.yy HH:mm}", "{date:d. MMMMM}", "{date:d. MMMMM yyyy}", "{date:EEE.}", "{content:none}", "{content:upper}", "{content:lower}", "{content:line1}", "{content:line2}"};

    public static String[] getDefaultPlaceholders() {
        return m_placeholders;
    }

    public static String[] getDefaultDateFormats() {
        return m_date_formats;
    }

    public static String linedashes2str(float[] fArray) {
        Object object = "";
        if (fArray != null && fArray.length != 0) {
            object = (String)object + String.valueOf((int)fArray[0]);
            for (int i = 1; i < fArray.length; ++i) {
                object = (String)object + " " + String.valueOf((int)fArray[i]);
            }
        }
        return object;
    }

    public static float[] str2linedashes(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split("\\s+");
        if (stringArray.length == 0) {
            return null;
        }
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                fArray[i] = Float.parseFloat(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    fArray[i] = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException2) {
                    return null;
                }
            }
        }
        return fArray;
    }

    public static String font2str(Font font) {
        String string = font.getFamily() + "-";
        string = font.isBold() && font.isItalic() ? string + "BOLDITALIC" : (font.isBold() ? string + "BOLD" : (font.isItalic() ? string + "ITALIC" : string + "PLAIN"));
        string = string + "-" + font.getSize();
        return string;
    }

    public static Font str2font(String string) {
        return Font.decode(string);
    }

    public static Color str2color(String string) {
        if (string == null) {
            return null;
        }
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String color2str(Color color) {
        if (color == null) {
            return "";
        }
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }
}

