/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class WpTimeUtils {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long MINUTES_PER_HOUR = 60L;
    public static final long HOURS_PER_DAY = 24L;
    public static final long DAYS_PER_WEEK = 7L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MILLIS_PER_WEEK = 604800000L;
    private static final String SDF_DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss Z";

    public static String now(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return WpTimeUtils.now(simpleDateFormat);
    }

    public static String now(SimpleDateFormat simpleDateFormat) {
        Calendar calendar = Calendar.getInstance();
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String date2str(Date date) {
        return new SimpleDateFormat(SDF_DEFAULT_FORMAT).format(date);
    }

    public static Date str2date(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SDF_DEFAULT_FORMAT);
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            try {
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException2) {
                simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
                try {
                    return simpleDateFormat.parse(string);
                }
                catch (ParseException parseException3) {
                    simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    try {
                        return simpleDateFormat.parse(string);
                    }
                    catch (ParseException parseException4) {
                        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        try {
                            return simpleDateFormat.parse(string);
                        }
                        catch (ParseException parseException5) {
                            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                            try {
                                return simpleDateFormat.parse(string);
                            }
                            catch (ParseException parseException6) {
                                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                try {
                                    return simpleDateFormat.parse(string);
                                }
                                catch (ParseException parseException7) {
                                    simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
                                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
                                    try {
                                        return simpleDateFormat.parse(string);
                                    }
                                    catch (ParseException parseException8) {
                                        simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
                                        try {
                                            return simpleDateFormat.parse(string);
                                        }
                                        catch (ParseException parseException9) {
                                            return null;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public static Date str2date(String string, Date date) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("h:mma");
        try {
            return WpTimeUtils.str2date_set_date(simpleDateFormat.parse(string.toUpperCase().replaceAll("[^0-9:APM]", "")), date);
        }
        catch (ParseException parseException) {
            simpleDateFormat = new SimpleDateFormat("HH:mm");
            try {
                return WpTimeUtils.str2date_set_date(simpleDateFormat.parse(string), date);
            }
            catch (ParseException parseException2) {
                simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                try {
                    return WpTimeUtils.str2date_set_date(simpleDateFormat.parse(string), date);
                }
                catch (ParseException parseException3) {
                    return null;
                }
            }
        }
    }

    private static Date str2date_set_date(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        if (date2 != null) {
            calendar2.setTime(date2);
        }
        calendar2.set(11, calendar.get(11));
        calendar2.set(12, calendar.get(12));
        calendar2.set(13, calendar.get(13));
        return new Date(calendar2.getTimeInMillis());
    }

    public static String secondsPrettyPrinter(int n) {
        if (n < 0) {
            return "-";
        }
        if (n < 60) {
            return n + "s";
        }
        if (n < 3600) {
            return n / 60 + "m";
        }
        if (n < 86400) {
            return n / 60 / 60 + "h";
        }
        return n / 60 / 60 / 24 + "d";
    }

    public static Date midnight_in_days(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, n);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static class WpDuration {
        public static int Secs;
        public static int Mins;
        public static int Hours;
        public static int Days;

        public static void convertMillisToDuration(long l) {
            Secs = (int)((l /= 1000L) % 60L);
            Mins = (int)((l /= 60L) % 60L);
            Hours = (int)((l /= 60L) % 24L);
            Days = (int)(l /= 24L);
        }
    }
}

