/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Set;

public class WpUtils {
    public static String bool2str(boolean bl) {
        return bl ? "true" : "false";
    }

    public static boolean str2bool(String string) {
        return string != null && string.equals("true");
    }

    public static String implode(String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            stringBuilder.append(object).append(string);
        }
        return stringBuilder.substring(0, stringBuilder.length() - string.length());
    }

    public static String implode(String string, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            stringBuilder.append(string2).append(string);
        }
        return stringBuilder.substring(0, stringBuilder.length() - string.length());
    }

    public static String implode(String string, Set<String> set) {
        if (set == null || set.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : set) {
            stringBuilder.append(string2).append(string);
        }
        return stringBuilder.substring(0, stringBuilder.length() - string.length());
    }

    public static String implode(String string, Collection<?> collection) {
        if (collection == null || collection.size() == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : collection) {
            stringBuilder.append(obj).append(string);
        }
        return stringBuilder.substring(0, stringBuilder.length() - string.length());
    }

    public static String sha1(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = messageDigest.digest(string.getBytes("UTF-8"));
            BigInteger bigInteger = new BigInteger(1, byArray);
            return bigInteger.toString(16);
        }
        catch (Exception exception) {
            return string.replaceAll("[^\\w]", "");
        }
    }

    public static String[] int2str(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = String.valueOf(nArray[i]);
        }
        return stringArray;
    }

    public static int[] str2int(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = 0;
            }
        }
        return nArray;
    }
}

