/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WpPasswords;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AdapterRange;
import de.wilke.wizepanel.core.adapters.ILicense;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public abstract class AbstractAdapterConfiguration
implements ILicense {
    private static final String CFG_ENABLED = "enabled";
    protected static final String CFG_SERVER = "server";
    protected static final String CFG_TYPE = "type";
    protected static final String CFG_USER = "user";
    private static final String CFG_PASSWORD = "password";
    protected static final String CFG_CALENDARS = "calendars";
    protected static final String CFG_INTERVAL = "interval";
    public static final String CFG_RANGE = "range";
    private static final String INTERVAL_HOURS = "h";
    private static final String INTERVAL_MINUTES = "m";
    private static final String INTERVAL_SECONDS = "s";
    private static final String LIST_SEP = ",";
    private String name;
    private int m_interval = 0;
    private final AdapterRange range = new AdapterRange();
    private Map<String, String> data = new HashMap<String, String>();
    private final String[] required_fields;

    public AbstractAdapterConfiguration(String string) {
        this.name = string;
        for (String string2 : this.required_fields = new String[]{CFG_ENABLED, CFG_SERVER, CFG_TYPE, CFG_USER, CFG_PASSWORD, CFG_CALENDARS, CFG_INTERVAL, CFG_RANGE}) {
            if (this.data.containsKey(string2)) continue;
            this.data.put(string2, "");
        }
    }

    public AbstractAdapterConfiguration(String string, String string2) {
        this(string);
        this.data.put(CFG_TYPE, string2);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void setType(String string) {
        this.data.put(CFG_TYPE, string);
    }

    public boolean isEnabled() {
        return WpUtils.str2bool(this.data.get(CFG_ENABLED));
    }

    public void setEnabled(boolean bl) {
        this.data.put(CFG_ENABLED, WpUtils.bool2str(bl));
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public String getDataAsString(String string) {
        try {
            return this.data.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getDataAsNumber(String string, int n) {
        try {
            return Integer.parseInt(this.data.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public boolean getDataAsBoolean(String string, boolean bl) {
        try {
            return Boolean.parseBoolean(this.data.get(string));
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public void setData(String string, List<String> list) {
        JSONArray jSONArray = new JSONArray(list);
        this.data.put(string, jSONArray.toString());
    }

    public void setData(String string, String[] stringArray) {
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < stringArray.length; ++i) {
            jSONArray.put((Object)stringArray[i]);
        }
        this.data.put(string, jSONArray.toString());
    }

    public void setData(String string, String string2) {
        this.data.put(string, string2);
    }

    public void setData(String string, int n) {
        this.data.put(string, String.valueOf(n));
    }

    public void setData(String string, boolean bl) {
        this.data.put(string, String.valueOf(bl));
    }

    public List<String> getDataAsList(String string) {
        String string2 = this.data.get(string);
        if (string2 == null || string2.isEmpty()) {
            return new LinkedList<String>();
        }
        try {
            JSONArray jSONArray = new JSONArray(string2);
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                linkedList.add(jSONArray.getString(i));
            }
            return linkedList;
        }
        catch (JSONException jSONException) {
            String[] stringArray = string2.split(LIST_SEP);
            if (stringArray == null || stringArray.length == 0) {
                return new LinkedList<String>();
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string3 : stringArray) {
                if (string3.isEmpty()) continue;
                linkedList.add(string3);
            }
            return linkedList;
        }
    }

    public String getType() {
        return this.data.get(CFG_TYPE);
    }

    public int getIntervalSecs() {
        return this.m_interval;
    }

    public final void setIntervalSecs(int n) {
        this.m_interval = n;
        this.data.put(CFG_INTERVAL, Integer.toString(this.m_interval) + INTERVAL_SECONDS);
    }

    public final AdapterRange range() {
        return this.range;
    }

    public final void setRangeDays(int n) {
        this.range.set(n + "d");
        this.data.put(CFG_RANGE, this.range.toString());
    }

    public boolean allowsSecondsInterval() {
        return false;
    }

    public boolean validate() {
        for (String string : this.required_fields) {
            if (this.data.containsKey(string)) continue;
        }
        return this.import_interval_and_range();
    }

    public void importRawData(Map<String, String> map) {
        for (String string : map.keySet()) {
            this.data.put(string, map.get(string));
        }
        this.import_interval_and_range();
    }

    private boolean import_interval_and_range() {
        int n = 0;
        String string = this.getDataAsString(CFG_INTERVAL);
        int n2 = 60;
        if (string.endsWith(INTERVAL_MINUTES)) {
            string = string.substring(0, string.length() - 1);
        } else if (string.endsWith(INTERVAL_SECONDS)) {
            string = string.substring(0, string.length() - 1);
            n2 = 1;
        } else if (string.endsWith(INTERVAL_HOURS)) {
            string = string.substring(0, string.length() - 1);
            n2 = 3600;
        }
        try {
            n = n2 * Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (n < 60 && !this.allowsSecondsInterval()) {
            n = 60;
        }
        this.setIntervalSecs(n);
        this.range.set(this.getDataAsString(CFG_RANGE));
        return true;
    }

    @Override
    public int requiredLicenseCount() {
        return 0;
    }

    @Override
    public abstract LicenseManager.LicensePackages requiredLicense();

    public abstract String getDescription();

    public abstract Map<String, Object> details();

    public List<String> getErrors() {
        return new LinkedList<String>();
    }

    public String toString() {
        return PrettyPrinter.condensed(this.details());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.data == null ? 0 : this.data.hashCode());
        n = 31 * n + this.m_interval;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractAdapterConfiguration abstractAdapterConfiguration = (AbstractAdapterConfiguration)object;
        if (this.data == null ? abstractAdapterConfiguration.data != null : !this.data.equals(abstractAdapterConfiguration.data)) {
            return false;
        }
        return this.m_interval == abstractAdapterConfiguration.m_interval;
    }

    public List<String> targets() {
        return null;
    }

    public String password() {
        return WpPasswords.decrypt(this.getDataAsString(CFG_PASSWORD));
    }

    public void setPassword(String string) {
        this.setData(CFG_PASSWORD, WpPasswords.encrypt(string));
    }

    public List<String> placeholders() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("DTSTART");
        linkedList.add("DTEND");
        linkedList.add("SUMMARY");
        linkedList.add("DESCRIPTION");
        linkedList.add("LOCATION");
        return linkedList;
    }
}

