/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AscTimeTablesAdapter
extends AbstractAdapterConfiguration {
    public static final String TYPE = "asc-timetables";
    public static final String OPTION_IGNORE_ALARM = "ignore-alarm";
    public static final String PLACEHOLDER_CLASSES = "CLASSES";

    public AscTimeTablesAdapter(String string) {
        super(string, TYPE);
        this.setIgnoreAlarm(false);
    }

    public String server() {
        return this.getDataAsString("server");
    }

    public void setServer(String string) {
        this.setData("server", string);
    }

    @Override
    public List<String> targets() {
        return this.getDataAsList("calendars");
    }

    public void setRooms(List<String> list) {
        this.setData("calendars", list);
    }

    public void setIgnoreAlarm(boolean bl) {
        this.setData(OPTION_IGNORE_ALARM, bl);
    }

    public boolean ignoreAlarm() {
        return this.getDataAsBoolean(OPTION_IGNORE_ALARM, false);
    }

    @Override
    public LicenseManager.LicensePackages requiredLicense() {
        return LicenseManager.LicensePackages.WZP_SOFT_ASC_TIMETABLES;
    }

    @Override
    public int requiredLicenseCount() {
        List<String> list = this.targets();
        return list != null ? list.size() : 0;
    }

    @Override
    public Map<String, Object> details() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("URL", this.server());
        treeMap.put("Rooms", WpUtils.implode(", ", this.targets()));
        return treeMap;
    }

    @Override
    public String getDescription() {
        return "aSc TimeTables";
    }

    @Override
    public List<String> placeholders() {
        List<String> list = super.placeholders();
        list.add(PLACEHOLDER_CLASSES);
        return list;
    }
}

