/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.types.CsvAdapterFormat;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONException;
import org.json.JSONObject;

public class CsvAdapter
extends AbstractAdapterConfiguration {
    public static final String TYPE = "csv";
    private static final String OPTION_ROOMS = "rooms";
    private static final String OPTION_FORMAT = "format";
    private static final String OPTION_ENCODING = "encoding";

    public CsvAdapter(String string) {
        super(string, TYPE);
        this.setRooms(new LinkedList<String>());
        this.setFormat(new CsvAdapterFormat());
        this.setEncoding("UTF-8");
    }

    public void setEncoding(String string) {
        this.setData(OPTION_ENCODING, string);
    }

    public String getEncoding() {
        return this.getDataAsString(OPTION_ENCODING);
    }

    public void setFormat(CsvAdapterFormat csvAdapterFormat) {
        try {
            this.setData(OPTION_FORMAT, csvAdapterFormat.toJSON().toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public CsvAdapterFormat getFormat() {
        try {
            return new CsvAdapterFormat(new JSONObject(this.getDataAsString(OPTION_FORMAT)));
        }
        catch (JSONException jSONException) {
            return new CsvAdapterFormat();
        }
    }

    public String getCsvFile() {
        List<String> list = this.getDataAsList("calendars");
        if (list != null && list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    public void setCsvFile(String string) {
        this.setData("calendars", string);
    }

    @Override
    public List<String> targets() {
        return this.getRooms();
    }

    public List<String> getRooms() {
        return this.getDataAsList(OPTION_ROOMS);
    }

    public void setRooms(List<String> list) {
        this.setData(OPTION_ROOMS, list);
    }

    @Override
    public boolean allowsSecondsInterval() {
        return WpFileUtils.isWeb(this.getCsvFile());
    }

    @Override
    public LicenseManager.LicensePackages requiredLicense() {
        return LicenseManager.LicensePackages.WZP_SOFT_EXCEL;
    }

    @Override
    public int requiredLicenseCount() {
        List<String> list = this.targets();
        return list != null ? list.size() : 0;
    }

    @Override
    public Map<String, Object> details() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("CSV Files", this.getCsvFile());
        treeMap.put("Rooms", this.requiredLicenseCount() == 0 ? "0" : WpUtils.implode(", ", this.targets()));
        treeMap.put("Encoding", this.getEncoding());
        return treeMap;
    }

    @Override
    public String getDescription() {
        return "CSV / MS Excel";
    }

    @Override
    public List<String> getErrors() {
        CsvAdapterFormat csvAdapterFormat;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = this.getCsvFile();
        if (string == null) {
            linkedList.add("CSV file not configured");
        }
        if ((csvAdapterFormat = this.getFormat()).getTargetCol() == 0) {
            linkedList.add("Target is not set");
        }
        if (csvAdapterFormat.getStartTimeDateCol() == 0) {
            linkedList.add("Start is not set");
        }
        if (csvAdapterFormat.getEndTimeDateCol() == 0) {
            linkedList.add("End is not set");
        }
        return linkedList;
    }

    @Override
    public List<String> placeholders() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("DTSTART");
        linkedList.add("DTEND");
        linkedList.addAll(this.getFormat().getPlaceholders().keySet());
        return linkedList;
    }
}

