/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ExchangeEMailAdapter
extends AbstractAdapterConfiguration {
    public static final String TYPE = "ms-email";
    public static final String OPTION_PRIVATE_EVENT_SUMMARY = "private-event-summary";

    public ExchangeEMailAdapter(String string) {
        super(string, TYPE);
        this.setPrivateEventSummary("");
    }

    public String server() {
        return this.getDataAsString("server");
    }

    public void setServer(String string) {
        this.setData("server", string);
    }

    public String user() {
        return this.getDataAsString("user");
    }

    public void setUser(String string) {
        this.setData("user", string);
    }

    @Override
    public LicenseManager.LicensePackages requiredLicense() {
        return LicenseManager.LicensePackages.WZP_SOFT_OUTL;
    }

    @Override
    public int requiredLicenseCount() {
        return 1;
    }

    @Override
    public Map<String, Object> details() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("URL", this.server());
        treeMap.put("User", this.user());
        return treeMap;
    }

    @Override
    public String getDescription() {
        return "MS Exchange 2003 (AutoAcceptAgent)";
    }

    public void setPrivateEventSummary(String string) {
        this.setData(OPTION_PRIVATE_EVENT_SUMMARY, string);
    }

    public String privateEventSummary() {
        return this.getDataAsString(OPTION_PRIVATE_EVENT_SUMMARY);
    }

    @Override
    public List<String> targets() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this.user());
        return linkedList;
    }
}

