/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.WpPasswords;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.types.GoogleCalendarAdapterFormat;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleCalendarAdapter
extends AbstractAdapterConfiguration {
    public static final String TYPE = "google-calendar";
    private static final String OPTION_DEFAULT_ALARM = "default_alarm";
    private static final String OPTION_FORMAT = "format";
    private static final String OPTION_ENCODING = "encoding";
    private static final String OPTION_ROOMS = "rooms";

    public GoogleCalendarAdapter(String string) {
        super(string, TYPE);
        this.setRooms(new LinkedList<String>());
        this.setFormat(new GoogleCalendarAdapterFormat());
        this.setDefaultAlarm(0);
        this.setEncoding("UTF-8");
    }

    public String server() {
        return WpPasswords.decrypt(this.getDataAsString("server"));
    }

    public void setEncoding(String string) {
        this.setData(OPTION_ENCODING, string);
    }

    public String getEncoding() {
        String string = this.getDataAsString(OPTION_ENCODING);
        if (string != null && !string.isEmpty()) {
            return string;
        }
        return "UTF-8";
    }

    public List<String> getRooms() {
        List<String> list = this.getDataAsList(OPTION_ROOMS);
        if (list.size() == 0) {
            list.add("EVENTS");
        }
        return list;
    }

    public void setRooms(List<String> list) {
        this.setData(OPTION_ROOMS, list);
    }

    public void setFormat(GoogleCalendarAdapterFormat googleCalendarAdapterFormat) {
        try {
            this.setData(OPTION_FORMAT, googleCalendarAdapterFormat.toJSON().toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public GoogleCalendarAdapterFormat getFormat() {
        try {
            return new GoogleCalendarAdapterFormat(new JSONObject(this.getDataAsString(OPTION_FORMAT)));
        }
        catch (Exception exception) {
            return new GoogleCalendarAdapterFormat();
        }
    }

    public void setServer(String string) {
        this.setData("server", WpPasswords.encrypt(string));
    }

    @Override
    public LicenseManager.LicensePackages requiredLicense() {
        return LicenseManager.LicensePackages.WZP_SOFT_GOOGLECALENDAR;
    }

    @Override
    public int requiredLicenseCount() {
        return 1;
    }

    @Override
    public Map<String, Object> details() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("URL", this.server());
        hashMap.put("DefaultAlarmTime", this.defaultAlarm());
        hashMap.put("Rooms", this.requiredLicenseCount() == 0 ? "0" : WpUtils.implode(", ", this.targets()));
        hashMap.put("Encoding", this.getEncoding());
        return hashMap;
    }

    @Override
    public String getDescription() {
        return "iCal / Google Calendar";
    }

    @Override
    public List<String> targets() {
        return this.getRooms();
    }

    public void setDefaultAlarm(int n) {
        this.setData(OPTION_DEFAULT_ALARM, n);
    }

    public int defaultAlarm() {
        return this.getDataAsNumber(OPTION_DEFAULT_ALARM, 0);
    }
}

