/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.types.ICalendarAdapterFormat;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ICalendarAdapter
extends AbstractAdapterConfiguration {
    public static final String TYPE = "icalendar";
    private static final String OPTION_ROOMS = "rooms";
    private static final String OPTION_DELETE_AFTER_DAYS = "delete_after_days";
    private static final String OPTION_DEFAULT_ALARM = "default_alarm";
    private static final String OPTION_FORMAT = "format";
    private static final String OPTION_ENCODING = "encoding";
    private static final int DEFAULT_DELETE_AFTER_DAYS = 0;
    public static final int DELETE_NEVER = -1;

    public ICalendarAdapter(String string) {
        super(string, TYPE);
        this.setRooms(new LinkedList<String>());
        this.setDeleteAfterDays(0);
        this.setFormat(new ICalendarAdapterFormat());
        this.setDefaultAlarm(0);
        this.setEncoding("UTF-8");
    }

    public void setEncoding(String string) {
        this.setData(OPTION_ENCODING, string);
    }

    public String getEncoding() {
        String string = this.getDataAsString(OPTION_ENCODING);
        if (string != null && !string.isEmpty()) {
            return string;
        }
        return "UTF-8";
    }

    public void setFormat(ICalendarAdapterFormat iCalendarAdapterFormat) {
        try {
            this.setData(OPTION_FORMAT, iCalendarAdapterFormat.toJSON().toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public ICalendarAdapterFormat getFormat() {
        try {
            return new ICalendarAdapterFormat(new JSONObject(this.getDataAsString(OPTION_FORMAT)));
        }
        catch (Exception exception) {
            return new ICalendarAdapterFormat();
        }
    }

    public String getWatchDir() {
        return this.getDataAsString("server");
    }

    public void setWatchDir(String string) {
        this.setData("server", string);
    }

    @Override
    public List<String> targets() {
        return this.getDataAsList(OPTION_ROOMS);
    }

    public void setRooms(List<String> list) {
        this.setData(OPTION_ROOMS, list);
    }

    public int deleteAfterDays() {
        return this.getDataAsNumber(OPTION_DELETE_AFTER_DAYS, 0);
    }

    public void setDeleteAfterDays(int n) {
        this.setData(OPTION_DELETE_AFTER_DAYS, n);
    }

    public void setDefaultAlarm(int n) {
        this.setData(OPTION_DEFAULT_ALARM, n);
    }

    public int defaultAlarm() {
        return this.getDataAsNumber(OPTION_DEFAULT_ALARM, 0);
    }

    @Override
    public boolean allowsSecondsInterval() {
        return true;
    }

    @Override
    public LicenseManager.LicensePackages requiredLicense() {
        return LicenseManager.LicensePackages.WZP_SOFT_ICALENDAR;
    }

    @Override
    public int requiredLicenseCount() {
        List<String> list = this.targets();
        return list != null ? list.size() : 0;
    }

    @Override
    public Map<String, Object> details() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Directory", this.getWatchDir());
        hashMap.put("Sources", WpUtils.implode(", ", this.targets()));
        hashMap.put("DeleteAfterDays", this.deleteAfterDays());
        hashMap.put("DefaultAlarmTime", this.defaultAlarm());
        hashMap.put("Encoding", this.getEncoding());
        return hashMap;
    }

    @Override
    public String getDescription() {
        return "iCal / ICS";
    }
}

