/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class WebUntisAdapter
extends AbstractAdapterConfiguration {
    public static final String TYPE = "webuntis";
    public static final String PH_LSTYPE = "LSTYPE";
    public static final String PH_CODE = "CODE";
    public static final String PH_INFO = "INFO";
    public static final String PH_SUBSTEXT = "SUBSTEXT";
    public static final String PH_LSTEXT = "LSTEXT";
    public static final String PH_ACTIVITY_TYPE = "ACTIVITY_TYPE";
    public static final String PH_SUBJECT_SHORT = "SUBJECT_SHORT";
    public static final String PH_SUBJECT_LONG = "SUBJECT_LONG";
    public static final String PH_TEACHER_SHORT = "TEACHER_SHORT";
    public static final String PH_TEACHER_LONG = "TEACHER_LONG";
    public static final String PH_CLASS_SHORT = "CLASS_SHORT";
    public static final String PH_CLASS_LONG = "CLASS_LONG";
    public static final String PH_ROOM_SHORT = "ROOM_SHORT";
    public static final String PH_ROOM_LONG = "ROOM_LONG";
    public static final String OPTION_ALARM = "alarm";
    public static final String OPTION_SCHOOL = "school";
    public static final String OPTION_TIMEZONE = "timezone";

    public WebUntisAdapter(String string) {
        super(string, TYPE);
        this.setSchool("");
        this.setTimezone("UTC");
    }

    public String server() {
        return this.getDataAsString("server");
    }

    public void setServer(String string) {
        this.setData("server", string);
    }

    public String user() {
        return this.getDataAsString("user");
    }

    public void setUser(String string) {
        this.setData("user", string);
    }

    public String school() {
        return this.getDataAsString(OPTION_SCHOOL);
    }

    public void setSchool(String string) {
        this.setData(OPTION_SCHOOL, string);
    }

    public String timezone() {
        return this.getDataAsString(OPTION_TIMEZONE);
    }

    public void setTimezone(String string) {
        this.setData(OPTION_TIMEZONE, string);
    }

    @Override
    public List<String> targets() {
        return this.getDataAsList("calendars");
    }

    public void setRooms(String[] stringArray) {
        this.setData("calendars", stringArray);
    }

    public void setAlarm(int n) {
        this.setData(OPTION_ALARM, n);
    }

    public int alarm() {
        return this.getDataAsNumber(OPTION_ALARM, 0);
    }

    @Override
    public LicenseManager.LicensePackages requiredLicense() {
        return LicenseManager.LicensePackages.WZP_SOFT_WEBUNTIS;
    }

    @Override
    public int requiredLicenseCount() {
        List<String> list = this.targets();
        return list != null ? list.size() : 0;
    }

    @Override
    public Map<String, Object> details() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("Rooms", WpUtils.implode(", ", this.targets()));
        treeMap.put("URL", this.server());
        treeMap.put("School", this.school());
        treeMap.put("Alarm", this.alarm());
        return treeMap;
    }

    @Override
    public String getDescription() {
        return "WebUntis HTTP / JSON";
    }

    @Override
    public List<String> placeholders() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("DTSTART");
        linkedList.add("DTEND");
        linkedList.add("SUMMARY");
        linkedList.add("DESCRIPTION");
        linkedList.add(PH_LSTYPE);
        linkedList.add(PH_CODE);
        linkedList.add(PH_INFO);
        linkedList.add(PH_SUBSTEXT);
        linkedList.add(PH_LSTEXT);
        linkedList.add(PH_ACTIVITY_TYPE);
        linkedList.add(PH_SUBJECT_SHORT);
        linkedList.add(PH_SUBJECT_LONG);
        linkedList.add(PH_TEACHER_SHORT);
        linkedList.add(PH_TEACHER_LONG);
        linkedList.add(PH_CLASS_SHORT);
        linkedList.add(PH_CLASS_LONG);
        linkedList.add(PH_ROOM_SHORT);
        linkedList.add(PH_ROOM_LONG);
        return linkedList;
    }
}

