/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class WilkeSimpleEventsAdapter
extends AbstractAdapterConfiguration {
    public static final String TYPE = "wilke-simple-events";
    public static final String OPTION_ONLY_MAIN_TARGETS = "onlyMainTargets";
    public static final String ALL_EVENTS_SOURCE = "_Overview";
    public static final String KEY_SE_MAIN_ROOM = "SE_MAIN_ROOM";

    public WilkeSimpleEventsAdapter(String string) {
        super(string, TYPE);
    }

    @Override
    public LicenseManager.LicensePackages requiredLicense() {
        return LicenseManager.LicensePackages.WZP_SOFT_BA;
    }

    public void setRooms(List<String> list) {
        this.setData("calendars", list);
    }

    @Override
    public List<String> targets() {
        List<String> list = this.getDataAsList("calendars");
        if (!list.contains(ALL_EVENTS_SOURCE)) {
            list.add(ALL_EVENTS_SOURCE);
        }
        return list;
    }

    @Override
    public String getDescription() {
        return "Simple Events";
    }

    @Override
    public Map<String, Object> details() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("Rooms", WpUtils.implode(", ", this.targets()));
        return treeMap;
    }

    public boolean onlyMainTargets() {
        return this.getDataAsBoolean(OPTION_ONLY_MAIN_TARGETS, false);
    }

    public void setOnlyMainTargets(boolean bl) {
        this.setData(OPTION_ONLY_MAIN_TARGETS, bl);
    }

    @Override
    public List<String> placeholders() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("DTSTART");
        linkedList.add("DTEND");
        linkedList.add("SUMMARY");
        linkedList.add("CREATOR");
        linkedList.add(KEY_SE_MAIN_ROOM);
        return linkedList;
    }
}

