/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.groups;

import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.groups.GroupData;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GroupManager {
    private static final String JId = "id";
    private static final String JTemplates = "templates";
    private static final String JAdapters = "adapters";
    private static final String JWizePanels = "wizepanels";
    private static final String JSimpleRooms = "simplerooms";
    private static final String JHistoryDuration = "historyduration";
    private static final String JTimeTableStart = "startofweek";
    private static final String JLocaleLang = "localelang";
    private final List<GroupData> groups = new LinkedList<GroupData>();
    private static final GroupManager instance = new GroupManager();

    public static GroupManager getManager() {
        return instance;
    }

    public boolean fromFile(String string) {
        String string2 = WpFileUtils.readTextFile(new File(string));
        return this.fromString(string2);
    }

    public void saveToFile(String string) {
        WpFileUtils.writeTextToFile(new File(string), this.toString());
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        try {
            for (GroupData groupData : this.groups) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put(JId, (Object)groupData.id);
                jSONObject2.put(JTemplates, groupData.templates);
                jSONObject2.put(JWizePanels, groupData.wizpanels);
                jSONObject2.put(JAdapters, groupData.adapters);
                jSONObject2.put(JSimpleRooms, groupData.simpleRooms);
                jSONObject2.put(JHistoryDuration, (Object)groupData.historyDuration);
                jSONObject2.put(JTimeTableStart, (Object)groupData.timeTableStart);
                jSONObject2.put(JLocaleLang, (Object)groupData.localeLang);
                jSONObject.put(groupData.name, (Object)jSONObject2);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject.toString();
    }

    public List<GroupData> getGroups() {
        return this.groups;
    }

    public GroupData getGroupByName(String string) {
        for (GroupData groupData : this.groups) {
            if (!groupData.name.equals(string)) continue;
            return groupData;
        }
        return null;
    }

    public List<String> getTemplatesForGroup(String string) {
        for (GroupData groupData : this.groups) {
            if (!string.equals(groupData.name)) continue;
            return groupData.templates;
        }
        return null;
    }

    public List<String> getPanelsForGroup(String string) {
        for (GroupData groupData : this.groups) {
            if (!string.equals(groupData.name)) continue;
            return groupData.wizpanels;
        }
        return null;
    }

    public void add(String string, String string2, List<String> list, List<String> list2, List<String> list3, List<String> list4, String string3, String string4, String string5) {
        this.remove(string);
        this.groups.add(new GroupData(string, string2, list, list2, list3, list4, string3, string4, string5));
    }

    public void add(GroupData groupData) {
        this.remove(groupData.name);
        this.groups.add(groupData);
    }

    public void remove(String string) {
        Iterator<GroupData> iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().name.equals(string)) continue;
            iterator.remove();
            return;
        }
    }

    public void clear() {
        this.groups.clear();
    }

    public boolean fromString(String string) {
        if (string == null) {
            return false;
        }
        this.groups.clear();
        if (string.equals("{}")) {
            return true;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.length() == 0) {
                return true;
            }
            for (String string2 : JSONObject.getNames((JSONObject)jSONObject)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                this.add(string2, jSONObject2.getString(JId), this.jArrayToList(jSONObject2.getJSONArray(JTemplates)), this.jArrayToList(jSONObject2.getJSONArray(JAdapters)), this.jArrayToList(jSONObject2.getJSONArray(JWizePanels)), this.jArrayToList(jSONObject2.getJSONArray(JSimpleRooms)), jSONObject2.getString(JHistoryDuration), jSONObject2.getString(JTimeTableStart), jSONObject2.getString(JLocaleLang));
            }
            return true;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return false;
        }
    }

    public List<String> jArrayToList(JSONArray jSONArray) throws JSONException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            arrayList.add(jSONArray.getString(i));
        }
        return arrayList;
    }
}

