/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.license;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONException;
import org.json.JSONObject;

public class License {
    private static final byte[] PUBLIC_KEY = new byte[]{48, -126, 1, -72, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 3, -127, -123, 0, 2, -127, -127, 0, -47, -112, 65, 126, 50, 15, -30, 66, 111, 43, 29, -119, -95, -79, -92, -95, 27, -13, -71, 118, -14, -22, -67, -74, 109, -49, 11, 108, -66, -39, -112, 39, 30, -62, -109, 126, -100, -81, -35, 110, -12, -121, 3, -124, 14, 41, -102, 42, -24, -52, -107, -77, 84, -70, -23, 68, -84, 70, -66, -96, -101, 104, 67, -27, -90, -9, 11, -108, 100, 74, -89, -122, 115, 93, -98, 73, 74, -119, -80, 51, 74, -83, 84, -113, -26, 8, -93, 59, -53, -105, 45, 116, 38, 57, 4, -23, 37, -107, 60, -124, 13, -9, 34, -47, -37, 71, -49, -6, -33, -54, 112, 65, -77, -88, 64, 82, -122, -98, -125, 68, 89, 125, 59, 106, 115, 122, 112, -41};
    private static final String KEY_CUSTOMER = "customer";
    private static final String KEY_LICENSE = "license";
    private static final String KEY_DATE = "date";
    private static final String KEY_EXPIRES = "expires";
    private static final String KEY_ORDER_NO = "order_no";
    private static final String KEY_SIGNATURE = "signature";
    private final String raw_string;
    private String signature = "";
    private final Map<String, String> fields = new TreeMap<String, String>();
    private boolean is_valid = false;
    private String error = null;
    private static PublicKey pubKey;

    public License(String string) {
        this.raw_string = string;
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.length() != 0) {
                for (String string2 : JSONObject.getNames((JSONObject)jSONObject)) {
                    this.fields.put(string2, jSONObject.getString(string2));
                }
            }
            if (!this.fields.containsKey(KEY_SIGNATURE)) {
                this.error = "No signature found";
                return;
            }
            this.signature = this.fields.remove(KEY_SIGNATURE);
            this.is_valid = this.verify_signature(pubKey, this.string2array(this.signature));
        }
        catch (Exception exception) {
            this.error = exception.getLocalizedMessage();
        }
    }

    public License(String string, String string2, String string3, String string4, String string5, PrivateKey privateKey) {
        this(null);
        try {
            this.fields.put(KEY_CUSTOMER, string);
            this.fields.put(KEY_ORDER_NO, string2);
            this.fields.put(KEY_LICENSE, string3);
            this.fields.put(KEY_DATE, string4);
            this.fields.put(KEY_EXPIRES, string5);
            this.signature = this.array2string(this.create_signature(string, string3, privateKey));
            this.is_valid = true;
        }
        catch (Exception exception) {
            this.error = exception.getLocalizedMessage();
            this.is_valid = false;
        }
    }

    private byte[] create_signature(String string, String string2, PrivateKey privateKey) throws SignatureException, InvalidKeyException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchProviderException {
        Signature signature = Signature.getInstance("SHA1withDSA");
        signature.initSign(privateKey);
        signature.update(this.data_to_sign());
        return signature.sign();
    }

    private boolean verify_signature(PublicKey publicKey, byte[] byArray) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        Signature signature = Signature.getInstance("SHA1withDSA");
        signature.initVerify(pubKey);
        signature.update(this.data_to_sign());
        return signature.verify(byArray);
    }

    public boolean hasValidFormat() {
        return this.is_valid;
    }

    public boolean isExpired() {
        String string = this.expires();
        if (string.isEmpty()) {
            return false;
        }
        try {
            Date date = License.parseDate(string);
            return !date.after(new Date());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String error() {
        return this.error;
    }

    private String key_field(String string) {
        if (this.fields.containsKey(string)) {
            return this.fields.get(string);
        }
        return "";
    }

    public String customer() {
        return this.key_field(KEY_CUSTOMER);
    }

    public String orderNo() {
        return this.key_field(KEY_ORDER_NO);
    }

    public String date() {
        return this.key_field(KEY_DATE);
    }

    public String expires() {
        return this.key_field(KEY_EXPIRES);
    }

    public String license() {
        return this.key_field(KEY_LICENSE);
    }

    public String toJSONString() {
        if (!this.is_valid) {
            return "";
        }
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string : this.fields.keySet()) {
                String string2 = this.fields.get(string);
                if (string2 == null || string2.isEmpty()) continue;
                jSONObject.put(string, (Object)this.fields.get(string));
            }
            jSONObject.put(KEY_SIGNATURE, (Object)this.signature);
            return jSONObject.toString(4);
        }
        catch (JSONException jSONException) {
            return "";
        }
    }

    public boolean writeToFile(File file) {
        boolean bl;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath()), "UTF-8"));
        try {
            bufferedWriter.write(this.toJSONString());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)bufferedWriter).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                this.error = exception.getMessage();
                return false;
            }
        }
        ((Writer)bufferedWriter).close();
        return bl;
    }

    public String rawString() {
        return this.raw_string;
    }

    private String array2string(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x", (short)(by & 0xFF)));
        }
        return stringBuilder.toString();
    }

    private byte[] string2array(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Short.parseShort(string.substring(i * 2, i * 2 + 2), 16);
        }
        return byArray;
    }

    private byte[] data_to_sign() throws UnsupportedEncodingException {
        Object object = "";
        for (String string : this.fields.keySet()) {
            String string2 = this.fields.get(string);
            if (string2 == null || string2.isEmpty()) continue;
            object = (String)object + string2 + "&";
        }
        if (((String)object).length() != 0) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return ((String)object).getBytes("UTF-8");
    }

    public static Date parseDate(String string) throws Exception {
        if (!string.matches("\\d\\d\\d\\d-\\d\\d-\\d\\d")) {
            throw new Exception("Invalid format");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.parse(string);
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }

    static {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(PUBLIC_KEY);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            pubKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

