/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.license;

import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.license.License;
import java.io.File;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LicenseManager {
    public static final String FILE = "${env_var:WIZEPANEL_HOME}/license.txt";
    private final Map<String, Integer> licenses = new HashMap<String, Integer>();
    private License license = null;

    public LicenseManager(File file, boolean bl) {
        this(WpFileUtils.readTextFile(file, Charset.forName("UTF-8")), bl);
    }

    public LicenseManager(String string, boolean bl) {
        this.licenses.put(LicensePackages.WZP_SOFT_BA.license_id, 5);
        if (string == null) {
            return;
        }
        this.license = new License(string);
        if (this.hasValidLicense() || this.exists() && this.license.hasValidFormat() && bl) {
            this.parse_license(this.license.license());
        }
    }

    public boolean exists() {
        return this.license != null;
    }

    public boolean hasValidLicense() {
        return this.exists() && this.license.hasValidFormat() && !this.license.isExpired();
    }

    public Map<String, Integer> getLicenses() {
        return this.licenses;
    }

    public boolean hasLicense(LicensePackages licensePackages) {
        if (licensePackages == LicensePackages.WZP_SOFT_BA) {
            return true;
        }
        if (licensePackages == LicensePackages.WZP_TEST_SOFT) {
            return this.licenses.containsKey(licensePackages.license_id);
        }
        return this.hasLicense(licensePackages.license_id);
    }

    public boolean hasLicense(String string) {
        if (string.equals(LicensePackages.WZP_SOFT_BA.toString())) {
            return true;
        }
        return this.licenses.containsKey(LicensePackages.WZP_SET_UPGRADE.toString()) || this.licenses.containsKey(string) && this.licenses.get(string) > 0;
    }

    public int getLicenseCount(LicensePackages licensePackages) {
        if (this.licenses.containsKey(licensePackages.license_id)) {
            return this.licenses.get(licensePackages.license_id);
        }
        return -1;
    }

    public int getLicensePanels(LicensePackages licensePackages) {
        return this.licenses.get(licensePackages.license_id);
    }

    public static LicenseManager getManager() {
        return new LicenseManager(new WpFile(FILE).getJavaFile(), false);
    }

    public String getResolvedLicenseFilePath() {
        return new WpFile(FILE).getResolvedFileName();
    }

    /*
     * WARNING - void declaration
     */
    private void parse_license(String string) {
        this.licenses.clear();
        this.licenses.put(LicensePackages.WZP_SOFT_BA.license_id, 0);
        String[] stringArray = string.split(",");
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (String string2 : stringArray) {
            void object;
            void var6_9;
            int n = 1;
            Pattern pattern = Pattern.compile("\\((\\d+)\\)");
            Matcher matcher = pattern.matcher(string2);
            if (matcher.find()) {
                String string3 = string2.replace(matcher.group(), "");
                try {
                    n = Integer.parseInt(matcher.group().substring(1, matcher.group().length() - 1));
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            int n2 = -1;
            String[] stringArray2 = var6_9.split("-");
            if (stringArray2.length >= 4) {
                String string4 = stringArray2[0] + "-" + stringArray2[1] + "-" + stringArray2[2];
                try {
                    n2 = Integer.parseInt(stringArray2[3]);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            n *= n2;
            if (this.licenses.containsKey(object)) {
                n += this.licenses.get(object).intValue();
            }
            this.licenses.put((String)object, n);
        }
    }

    public String toString() {
        LinkedList<CallSite> linkedList = new LinkedList<CallSite>();
        for (String string : this.licenses.keySet()) {
            String object = string + "-" + this.licenses.get(string);
            linkedList.add((CallSite)((Object)object));
        }
        return WpUtils.implode(" ", linkedList);
    }

    public License license() {
        return this.license;
    }

    public static enum LicensePackages {
        WZP_SOFT_BA("WZP-SOFT-BA", "Base (UNLIMITED =0)", "", false),
        WZP_SOFT_EXCEL("WZP-SOFT-EXCEL", "MS Excel/CSV", "WZP-SW-EX-001-01", true),
        WZP_SOFT_OUTL("WZP-SOFT-OUTL", "MS Exchange", "WZP-SW-OL-001-01", true),
        WZP_SOFT_EXGRAPH("WZP-SOFT-EXCHANGEGRAPH", "MS Exchange 365 (Graph)", "WZP-SW-MSGR-002-02", true),
        WZP_SOFT_WEBUNTIS("WZP-SOFT-WEBUNTIS", "WebUntis (HTTP/JSON)", "WZP-SW-UNTS-002-02", true),
        WZP_SOFT_XML("WZP-SOFT-XML", "XML", "WZP-SW-XML-001-01", true),
        WZP_SOFT_DEA_EMS("WZP-SOFT-DEAEMS", "Dea EMS", "", true),
        WZP_SOFT_ASC_TIMETABLES("WZP-SOFT-ASCTIMETABLES", "Asc Time Tables", "", true),
        WZP_SOFT_WILKE_HTTP_GENERAL("WZP-SOFT-WILKEHTTPGENERAL", "Wilke HTTP", "", true),
        WZP_SOFT_ICALENDAR("WZP-SOFT-ICALENDAR", "iCalendar", "WZP-SW-ICAL-001-01", true),
        WZP_SOFT_GOOGLECALENDAR("WZP-SOFT-GOOGLECALENDAR", "Google Calendar", "WZP-SW-GCAL-001-01", true),
        WZP_SOFT_BRANCHE("WZP-SOFT-BRANCHE", "UPI", "WZP-SW-IF-001-01", true),
        WZP_HARD_WIZESCREEN("WZP-HARD-WIZESCREEN", "WizeScreen", "WZP-SW-WSW/L-001-01", false),
        WZP_SET_UPGRADE("WZP-SET-UPGRADE", "???", "", false),
        WZP_SOFT_UPDATE("WZP-SOFT-UPDATE", "???", "", false),
        WZP_TEST_SOFT("WZP-TEST-SOFT", "[Intern]", "", false);

        public final String license_id;
        public final String description;
        public final String product_code;
        public final boolean base_required;

        private LicensePackages(String string2, String string3, String string4, boolean bl) {
            this.license_id = string2;
            this.description = string3;
            this.product_code = string4;
            this.base_required = bl;
        }

        public String toString() {
            return this.license_id;
        }
    }
}

