/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.locator;

import de.wilke.wizepanel.core.WpCore;
import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.locator.IWpLocatorPropertyType;
import de.wilke.wizepanel.core.locator.WPProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;

public abstract class AWpLocator {
    private String propFileFullName = "";
    private final HashMap<String, String> _props = new HashMap();
    private final WPProperties properties = new WPProperties();
    private final List<String> errors = new LinkedList<String>();

    public AWpLocator(String string, IWpLocatorPropertyType[] iWpLocatorPropertyTypeArray) {
        this.propFileFullName = WpCore.homeDir() + "/" + string;
        this.initProps(iWpLocatorPropertyTypeArray);
    }

    public void loadNativeProperties() {
        try {
            this.properties.load(new FileInputStream(new File(this.propFileFullName)));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getNativeProperty(String string) {
        if (this.properties.isEmpty()) {
            this.loadNativeProperties();
        }
        return this.properties.getProperty(string);
    }

    public String getProperty(String string) {
        return this._props.get(string);
    }

    public String getProperty(IWpLocatorPropertyType iWpLocatorPropertyType) {
        return this.getProperty(iWpLocatorPropertyType.getName());
    }

    public void setProperty(String string, String string2) {
        this._props.put(string, string2);
        this.properties.put(string, string2);
    }

    public void setProperty(IWpLocatorPropertyType iWpLocatorPropertyType, String string) {
        this.setProperty(iWpLocatorPropertyType.getName(), string);
    }

    public String getString(String string) {
        return this.getProperty(string);
    }

    public String getString(IWpLocatorPropertyType iWpLocatorPropertyType) {
        return this.getString(iWpLocatorPropertyType.getName());
    }

    public boolean getBoolean(IWpLocatorPropertyType iWpLocatorPropertyType) {
        return WpUtils.str2bool(this.getProperty(iWpLocatorPropertyType));
    }

    public void setString(String string, String string2) {
        this.setProperty(string, string2);
    }

    public void setString(IWpLocatorPropertyType iWpLocatorPropertyType, String string) {
        this.setString(iWpLocatorPropertyType.getName(), string);
    }

    public int getInt(String string) {
        return Integer.parseInt(this.getString(string));
    }

    public int getInt(IWpLocatorPropertyType iWpLocatorPropertyType) {
        return this.getInt(iWpLocatorPropertyType.getName());
    }

    public void setInt(String string, int n) {
        this.setString(string, Integer.toString(n));
    }

    public void setInt(IWpLocatorPropertyType iWpLocatorPropertyType, int n) {
        this.setString(iWpLocatorPropertyType.getName(), Integer.toString(n));
    }

    public void initProps(IWpLocatorPropertyType[] iWpLocatorPropertyTypeArray) {
        this.errors.clear();
        if (0 >= iWpLocatorPropertyTypeArray.length) {
            return;
        }
        for (IWpLocatorPropertyType iWpLocatorPropertyType : iWpLocatorPropertyTypeArray) {
            Object object = iWpLocatorPropertyType.getValue();
            try {
                String string;
                if (iWpLocatorPropertyType.isFileOrDirectory()) {
                    object = WpCore.homeDir() + "/" + (String)object;
                    string = this.getNativeProperty(iWpLocatorPropertyType.getName());
                    if (string != null) {
                        object = WpFileUtils.getAbsoluteFileExt(WpCore.homeDir() + "/" + string).getAbsolutePath();
                    }
                    if (!new File((String)object).exists()) {
                        String string2 = iWpLocatorPropertyType.getName() + ": File/Directory does not exist: " + (String)object;
                        this.errors.add(string2);
                    }
                } else {
                    string = this.getNativeProperty(iWpLocatorPropertyType.getName());
                    if (string != null) {
                        object = string;
                    }
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (iWpLocatorPropertyType.getName() == "wizepanel.templates_dir") {
                this.setProperty("wizepanel.templates_dir_backup", iWpLocatorPropertyType.getValue());
            }
            this.setProperty(iWpLocatorPropertyType.getName(), (String)object);
        }
    }

    public void saveProps() {
        try {
            this.properties.store(new FileOutputStream(new File(this.propFileFullName)), "");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

