/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.locator;

import de.wilke.wizepanel.core.WpCore;
import de.wilke.wizepanel.core.locator.AWpLocator;
import de.wilke.wizepanel.core.locator.IWpLocatorPropertyType;

public class WpSystemLocator
extends AWpLocator {
    private final String m_current_lang = "en";
    private static final WpSystemLocator _singleton = new WpSystemLocator();

    private WpSystemLocator() {
        super("conf/wizepanel.properties", WpSystemLocatorPropType.values());
    }

    public String getLanguagesDir() {
        return WpCore.homeDir() + "/conf/languages";
    }

    public String getDefaultLanguage() {
        return "en";
    }

    public String getImagesDir() {
        return this.getProperty(WpSystemLocatorPropType.IMAGES_DIR.name);
    }

    public String getFactoryImagesDir() {
        return this.getProperty(WpSystemLocatorPropType.FACTORY_IMAGES_DIR.name);
    }

    public String getCursorsDir() {
        return this.getProperty(WpSystemLocatorPropType.CURSORS_DIR.name);
    }

    public String getAppPrefsDir() {
        return this.getProperty(WpSystemLocatorPropType.APP_PREFS_DIR.name);
    }

    public final String getTemplateDir() {
        return this.getProperty(WpSystemLocatorPropType.TEMPLATES_DIR.name);
    }

    public final String getPluginsDir() {
        return this.getProperty(WpSystemLocatorPropType.PLUGINS_DIR.name);
    }

    public final String getDisplaysFile() {
        return this.getProperty(WpSystemLocatorPropType.DISPLAYS_FILE.name);
    }

    public final String getEventsDir() {
        return this.getProperty(WpSystemLocatorPropType.EVENTS_DIR.name);
    }

    public final String getRulesDBFile() {
        return this.getProperty(WpSystemLocatorPropType.RULES_DB_FILE.name);
    }

    public final String getResourcesWatchDir() {
        return this.getProperty(WpSystemLocatorPropType.RESOURCES_WATCH_DIR.name);
    }

    public final String getCommandsWatchDir() {
        return this.getProperty(WpSystemLocatorPropType.COMMANDS_WATCH_DIR.name);
    }

    public final String getResourcesDir() {
        return this.getProperty(WpSystemLocatorPropType.RESOURCES_DIR.name);
    }

    public final String getFinalResourcesDir() {
        return this.getProperty(WpSystemLocatorPropType.FINAL_RESOURCES_DIR.name);
    }

    public final String getFinalImgResourcesDir() {
        return this.getProperty(WpSystemLocatorPropType.FINAL_IMG_RESOURCES_DIR.name);
    }

    public final String getAdaptersCfg() {
        return this.getProperty(WpSystemLocatorPropType.ADAPTERS_FILE.name);
    }

    public static WpSystemLocator getLocator() {
        return _singleton;
    }

    public void setDateTimeLocale(String string) {
        this.setProperty(WpSystemLocatorPropType.DATETIME_LOCALE.name, string);
    }

    public final String getDateTimeLocale() {
        return this.getProperty(WpSystemLocatorPropType.DATETIME_LOCALE.name);
    }

    public void setEventHistoryDuration(String string) {
        this.setProperty(WpSystemLocatorPropType.EVENT_HISTORY_DURATION.name, string);
    }

    public final String getEventHistoryDuration() {
        return this.getProperty(WpSystemLocatorPropType.EVENT_HISTORY_DURATION.name);
    }

    public void setTimetableStartDay(String string) {
        this.setProperty(WpSystemLocatorPropType.TIMETABLE_START_DAY.name, string);
    }

    public final String getTimetableStartDay() {
        return this.getProperty(WpSystemLocatorPropType.TIMETABLE_START_DAY.name);
    }

    @Override
    public void saveProps() {
        super.saveProps();
    }

    public static enum WpSystemLocatorPropType implements IWpLocatorPropertyType
    {
        APP_PREFS_DIR("wizepanel.conf/apps/", "conf/apps", true),
        TEMPLATES_DIR("wizepanel.templates_dir", "system/templates", true),
        DATETIME_LOCALE("wizepanel.locale", "", false),
        EVENT_HISTORY_DURATION("wizepanel.eventhistoryduration", "604800000", false),
        TIMETABLE_START_DAY("wizepanel.timetablestartday", "2", false),
        LANGUAGES_DIR("wizepanel.languages_dir", "conf/languages", true),
        IMAGES_DIR("wizepanel.images_dir", "conf/images", true),
        CURSORS_DIR("wizepanel.cursors_dir", "conf/images/cursors", true),
        FACTORY_IMAGES_DIR("wizepanel.factory_images_dir", "conf/images/factory", true),
        DISPLAYS_FILE("wizepanel.displays_file", "system/displays.xml", true),
        PLUGINS_DIR("wizepanel.lib_dir", "lib/", true),
        PLUGINS_WILKE_DIR("wizepanel.lib_wilke_dir", "lib/wilke", true),
        PLUGINS_EXTERN_DIR("wizepanel.lib_extern_dir", "lib/extern", true),
        EVENTS_DIR("wizepanel.events_dir", "system/events", true),
        EVENTS_SPOOL_DIR("wizepanel.events_spool_dir", "system/events/spool", true),
        EVENTS_ALLOW_EXPIRED("wizepanel.events_allow_expired", "false", false),
        RULES_DB_FILE("wizepanel.rules_db_file", "system/rules.xml", true),
        RESOURCES_WATCH_DIR("wizepanel.resources_watch_dir", "system/resources/spool", true),
        RESOURCES_CSV_WATCH_DIR("wizepanel.resources_csv_watch_dir", "system/resources/spool/csv", true),
        COMMANDS_WATCH_DIR("wizepanel.commands_watch_dir", "system/commands/spool", true),
        COMMANDS_WATCH_RESPONSE_DIR("wizepanel.commands_watch_response_dir", "system/commands/responses", true),
        IDE_CONFIG_FILE("wizepanel.ide_config_file", "conf/apps/ide.xml", false),
        IDE_GROUPS_FILE("wizepanel.ide_groups_file", "system/groups.xml", true),
        RESOURCES_DIR("wizepanel.resources_dir", "system/resources", true),
        FINAL_RESOURCES_DIR("wizepanel.resources_final_dir", "system/resources/final", true),
        FINAL_IMG_RESOURCES_DIR("wizepanel.resources_final_img_dir", "system/resources/final/wpimages", true),
        FINAL_IMG_SMALL_RESOURCES_DIR("wizepanel.resources_final_img_small_dir", "system/resources/final/wpimages/small", true),
        HIBERNATE_FILE("wizepanel.hibernate", "conf/hibernate.cfg.xml", true),
        ADAPTERS_FILE("wizepanel.adapters", "conf/adapters.properties", true),
        UPI_ROUTING_FILE("wizepanel.upi_routing_file", "system/upirouting.xml", true),
        UPI_CONNECTION_TIMEOUT("wizepanel.upi_connection_timeout", "-1", false),
        CLEANUP_DONE_ICS_FILE("eventmanager.cleanup_done_ics_files", "7", false),
        CLEANUP_FINAL_IMAGES("eventmanager.cleanup_final_images", "1", false);

        private final String name;
        private final String value;
        private final boolean is_file_or_directory;

        private WpSystemLocatorPropType(String string2, String string3, boolean bl) {
            this.name = string2;
            this.value = string3;
            this.is_file_or_directory = bl;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isFileOrDirectory() {
            return this.is_file_or_directory;
        }
    }
}

