/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.misc;

public class InputByteStream {
    private final byte[] data;
    private int read_pos = 0;

    public InputByteStream(byte[] byArray) {
        this.data = byArray;
    }

    public InputByteStream(int[] nArray) {
        this.data = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.data[i] = (byte)(nArray[i] & 0xFF);
        }
    }

    public int bytesAvailable() {
        return this.data.length - this.read_pos;
    }

    public void reset() {
        this.read_pos = 0;
    }

    public short get8bit() {
        return (short)(this.data[this.read_pos++] & 0xFF);
    }

    public int get16bit() {
        int n = 0;
        n += (this.data[this.read_pos + 0] & 0xFF) << 0;
        this.read_pos += 2;
        return n += (this.data[this.read_pos + 1] & 0xFF) << 8;
    }

    public long get32bit() {
        int n = 0;
        n += (this.data[this.read_pos + 0] & 0xFF) << 0;
        n += (this.data[this.read_pos + 1] & 0xFF) << 8;
        n += (this.data[this.read_pos + 2] & 0xFF) << 16;
        this.read_pos += 4;
        return n += (this.data[this.read_pos + 3] & 0xFF) << 24;
    }

    public String getString(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.data[this.read_pos++];
        }
        return String.valueOf(cArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("size:").append(this.data.length).append(" HEX:[");
        for (byte by : this.data) {
            stringBuilder.append(String.format(" %02x", by & 0xFF));
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

