/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.misc;

public class OutputByteStream {
    private final byte[] data;
    private int write_pos = 0;

    public OutputByteStream(byte[] byArray) {
        this.data = byArray;
    }

    public OutputByteStream(byte[] byArray, int n) {
        this.data = byArray;
        this.write_pos = n;
    }

    public OutputByteStream(int n) {
        this.data = new byte[n];
    }

    public byte[] getData() {
        return this.data;
    }

    public void put8bit(short s) {
        this.data[this.write_pos++] = (byte)(s & 0xFF);
    }

    public void put16bit(int n) {
        this.data[this.write_pos++] = (byte)(n >> 0 & 0xFF);
        this.data[this.write_pos++] = (byte)(n >> 8 & 0xFF);
    }

    public void put32bit(long l) {
        this.data[this.write_pos++] = (byte)(l >> 0 & 0xFFL);
        this.data[this.write_pos++] = (byte)(l >> 8 & 0xFFL);
        this.data[this.write_pos++] = (byte)(l >> 16 & 0xFFL);
        this.data[this.write_pos++] = (byte)(l >> 24 & 0xFFL);
    }

    public void putString(String string) {
        byte[] byArray = string.getBytes();
        System.arraycopy(byArray, 0, this.data, this.write_pos, byArray.length);
        this.write_pos += byArray.length;
    }

    public boolean isFull() {
        return this.data.length == this.write_pos;
    }

    public int length() {
        return this.data.length;
    }
}

