/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.server;

import de.wilke.wizepanel.core.server.ServerMessage;
import de.wilke.wizepanel.core.server.WPServerConstants;

public class ServerReply
extends ServerMessage {
    private static final String REPLY_OK = "OK ";
    private static final String REPLY_NOTCHANGED = "NOTCHANGED ";
    private static final String REPLY_ERR = "ERR ";

    public ServerReply() {
        super("");
    }

    public ServerReply(String string) {
        super(string);
    }

    public void setError(String string) {
        this.setMessage(REPLY_ERR + string);
    }

    public void setOK(String string) {
        this.setMessage(REPLY_OK + string);
    }

    public void setNotChanged() {
        this.setMessage(REPLY_NOTCHANGED);
    }

    public boolean isError() {
        return this.getMessage().startsWith(REPLY_ERR);
    }

    public boolean notChanged() {
        return this.getMessage().startsWith(REPLY_NOTCHANGED);
    }

    public String getContent() {
        if (this.isError()) {
            return this.getMessage().substring(REPLY_ERR.length());
        }
        if (this.notChanged()) {
            return this.getMessage().substring(REPLY_NOTCHANGED.length());
        }
        return this.getMessage().substring(REPLY_OK.length());
    }

    public String toLog(WPServerConstants wPServerConstants) {
        if (wPServerConstants.reply_log) {
            return this.toString();
        }
        return wPServerConstants.name() + " +" + this.getMessage().length() + " data bytes";
    }
}

