/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.server;

import de.wilke.wizepanel.core.server.WPServerConstants;

public class ServerRequest {
    private final WPServerConstants cmd;
    private final long hash;
    private final String data;

    public ServerRequest(String string) throws Exception {
        String[] stringArray = string.split(" ", 3);
        if (stringArray == null || stringArray.length != 3) {
            throw new Exception("Wrong number of arguments!");
        }
        this.cmd = WPServerConstants.valueOf(stringArray[0]);
        this.hash = Long.parseLong(stringArray[1]);
        this.data = stringArray[2];
    }

    public ServerRequest(WPServerConstants wPServerConstants, long l, String string) {
        this.cmd = wPServerConstants;
        this.hash = l;
        this.data = string;
    }

    public WPServerConstants getCommand() {
        return this.cmd;
    }

    public long getHash() {
        return this.hash;
    }

    public String getData() {
        return this.data;
    }

    public String toString() {
        return this.cmd.name() + " " + this.hash + " " + this.data;
    }

    public String toLog() {
        if (this.cmd.request_log) {
            return this.toString();
        }
        return this.cmd.name() + " " + this.hash + " +" + this.data.length() + " data bytes";
    }
}

