/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.server.transfer;

import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.server.transfer.EventListEntry;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventList {
    private static final String KEY_ID = "id";
    private static final String KEY_IS_SIMPLE_EVENTS = "is_simple_events";
    private static final String KEY_ADAPTER_NAME = "adapter_name";
    private static final String KEY_ADAPTER_SOURCE = "adapter_source";
    private static final String KEY_SUBJECT = "subject";
    private static final String KEY_DETAILS = "details";
    private static final String KEY_DISPLAY_ON = "display_on";
    private static final String KEY_START = "start";
    private static final String KEY_END = "end";
    private static final String KEY_IS_SIMPLE_EVENTS_NON_MAIN = "isSimpleEventsNonMain";
    private final List<EventListEntry> entries = new LinkedList<EventListEntry>();

    public EventList() {
    }

    public EventList(String string) throws JSONException {
        JSONArray jSONArray = new JSONArray(string);
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            this.addEvent(jSONObject.getString(KEY_ID), jSONObject.getBoolean(KEY_IS_SIMPLE_EVENTS), jSONObject.getString(KEY_ADAPTER_NAME), jSONObject.getString(KEY_ADAPTER_SOURCE), jSONObject.getString(KEY_SUBJECT), WpTimeUtils.str2date(jSONObject.getString(KEY_START)), WpTimeUtils.str2date(jSONObject.getString(KEY_END)), jSONObject.getString(KEY_DETAILS), WpTimeUtils.str2date(jSONObject.getString(KEY_DISPLAY_ON)), jSONObject.getBoolean(KEY_IS_SIMPLE_EVENTS_NON_MAIN));
        }
    }

    public void addEvent(EventListEntry eventListEntry) {
        this.entries.add(eventListEntry);
    }

    public void addEvent(String string, boolean bl, String string2, String string3, String string4, Date date, Date date2, String string5, Date date3, boolean bl2) {
        this.entries.add(new EventListEntry(string, bl, string2, string3, string4, date, date2, string5, date3, bl2));
    }

    public List<EventListEntry> entries() {
        return this.entries;
    }

    public void sort() {
        Collections.sort(this.entries, new Comparator<EventListEntry>(){

            @Override
            public int compare(EventListEntry eventListEntry, EventListEntry eventListEntry2) {
                if (eventListEntry.display_on.after(eventListEntry2.display_on)) {
                    return 1;
                }
                if (eventListEntry.display_on.before(eventListEntry2.display_on)) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public void sortForView() {
        Collections.sort(this.entries, new Comparator<EventListEntry>(){
            Date now = new Date();
            EventState o1State = EventState.Future;
            EventState o2State = EventState.Future;

            @Override
            public int compare(EventListEntry eventListEntry, EventListEntry eventListEntry2) {
                this.o1State = eventListEntry.start.before(this.now) && eventListEntry.end.before(this.now) ? EventState.Expired : (eventListEntry.start.before(this.now) && eventListEntry.end.after(this.now) ? EventState.Current : EventState.Future);
                this.o2State = eventListEntry2.start.before(this.now) && eventListEntry2.end.before(this.now) ? EventState.Expired : (eventListEntry2.start.before(this.now) && eventListEntry2.end.after(this.now) ? EventState.Current : EventState.Future);
                if (this.o1State == this.o2State) {
                    if (eventListEntry.start.before(eventListEntry2.start)) {
                        return -1;
                    }
                    if (eventListEntry.start.after(eventListEntry2.start)) {
                        return 1;
                    }
                } else {
                    if (this.o1State == EventState.Expired) {
                        return -1;
                    }
                    if (this.o1State == EventState.Current) {
                        if (this.o2State == EventState.Expired) {
                            return 1;
                        }
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
        });
    }

    public String toJSONString() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (EventListEntry eventListEntry : this.entries) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(KEY_ID, (Object)eventListEntry.id);
            jSONObject.put(KEY_IS_SIMPLE_EVENTS, eventListEntry.is_simple_events);
            jSONObject.put(KEY_ADAPTER_NAME, (Object)eventListEntry.adapter_name);
            jSONObject.put(KEY_ADAPTER_SOURCE, (Object)eventListEntry.adapter_source);
            jSONObject.put(KEY_SUBJECT, (Object)eventListEntry.subject);
            jSONObject.put(KEY_START, (Object)WpTimeUtils.date2str(eventListEntry.start));
            jSONObject.put(KEY_END, (Object)WpTimeUtils.date2str(eventListEntry.end));
            jSONObject.put(KEY_DETAILS, (Object)eventListEntry.details);
            jSONObject.put(KEY_DISPLAY_ON, (Object)WpTimeUtils.date2str(eventListEntry.display_on));
            jSONObject.put(KEY_IS_SIMPLE_EVENTS_NON_MAIN, eventListEntry.isSimpleEventsNonMain);
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray.toString();
    }

    static enum EventState {
        Expired,
        Current,
        Future;

    }
}

