/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.users;

import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.WpPasswords;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.users.UserData;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

public class UserManager {
    private static final String sUser = "monitor0monitor0monitor0monitor";
    private static final String JROLE = "role";
    private static final String JID = "id";
    private static final String JPASSWORD = "password";
    private static final String JGROUP = "group";
    private static final String JMAINGP = "maingp";
    private final List<UserData> users = new LinkedList<UserData>();
    private static final UserManager instance = new UserManager();

    private UserManager() {
    }

    public static UserManager getManager() {
        return instance;
    }

    public boolean fromFile(String string) {
        String string2 = WpFileUtils.readTextFile(new File(string));
        return this.fromString(string2);
    }

    public void saveToFile(String string) {
        WpFileUtils.writeTextToFile(new File(string), this.toString());
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        try {
            for (UserData userData : this.users) {
                if (userData.name.equals(sUser)) continue;
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put(JROLE, (Object)userData.role.name());
                jSONObject2.put(JPASSWORD, (Object)WpPasswords.encrypt(userData.password));
                jSONObject2.put(JGROUP, (Object)userData.assignedGroup);
                jSONObject2.put(JMAINGP, (Object)userData.mainGroup);
                jSONObject2.put(JID, (Object)userData.id);
                jSONObject.put(userData.name, (Object)jSONObject2);
            }
            return jSONObject.toString(4);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return jSONObject.toString();
        }
    }

    public List<UserData> getUsers() {
        return this.users;
    }

    public void add(String string, String string2, UserData.UserRole userRole, String string3, String string4, String string5) {
        this.remove(string);
        this.users.add(new UserData(string, string2, userRole, string3, string4, string5));
    }

    public void add(String string, String string2, UserData.UserRole userRole, String string3, String string4) {
        this.add(string, string2, userRole, string3, string4, String.valueOf(10000000 + new Random().nextInt(90000000)));
    }

    public void replace(String string, String string2, String string3, UserData.UserRole userRole, String string4, String string5) {
        String string6 = this.getUser((String)string).id;
        this.remove(string);
        this.add(string2, string3, userRole, string4, string5, string6);
    }

    public void remove(String string) {
        Iterator<UserData> iterator = this.users.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().name.equals(string)) continue;
            iterator.remove();
            return;
        }
    }

    public void clear() {
        this.users.clear();
    }

    public boolean fromString(String string) {
        if (string == null) {
            return false;
        }
        this.users.clear();
        try {
            JSONObject jSONObject = new JSONObject(string);
            if (jSONObject.length() == 0) {
                return false;
            }
            for (String string2 : JSONObject.getNames((JSONObject)jSONObject)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                UserData.UserRole userRole = UserData.UserRole.ADMIN;
                for (UserData.UserRole userRole2 : UserData.UserRole.values()) {
                    if (!userRole2.name().equalsIgnoreCase(jSONObject2.getString(JROLE))) continue;
                    userRole = userRole2;
                    break;
                }
                if (string2.equals(sUser)) continue;
                this.add(string2, WpPasswords.decrypt(jSONObject2.getString(JPASSWORD)), userRole, jSONObject2.getString(JGROUP), jSONObject2.getString(JMAINGP), jSONObject2.getString(JID));
            }
            return true;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return false;
        }
    }

    public UserData checkUser(String string, String string2) {
        for (UserData userData : this.users) {
            String string3 = WpUtils.sha1(userData.name);
            String string4 = WpUtils.sha1(userData.password);
            if (!string3.equals(string) || !string4.equals(string2)) continue;
            return userData;
        }
        return null;
    }

    public UserData getUser(String string) {
        for (UserData userData : this.users) {
            if (!userData.name.equals(string)) continue;
            return userData;
        }
        return null;
    }
}

