/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.warnings;

import de.wilke.wizepanel.core.warnings.WarningListEntry;
import de.wilke.wizepanel.core.warnings.WarningsChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WarningList {
    private static final String KEY_TYPE = "type";
    private static final String KEY_SOURCE = "source";
    private static final String KEY_SOURCE_DETAILS = "source_details";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_MESSAGE = "message";
    private final List<WarningListEntry> entries = new LinkedList<WarningListEntry>();
    private final Set<WarningsChangeListener> m_change_listeners = new HashSet<WarningsChangeListener>();

    public void fromJSON(String string) throws JSONException {
        this.entries.clear();
        JSONArray jSONArray = new JSONArray(string);
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            this.entries.add(new WarningListEntry(WarningListEntry.Type.valueOf(jSONObject.getString(KEY_TYPE)), WarningListEntry.Source.valueOf(jSONObject.getString(KEY_SOURCE)), jSONObject.getString(KEY_SOURCE_DETAILS), jSONObject.getLong(KEY_TIMESTAMP), jSONObject.getString(KEY_MESSAGE)));
        }
        this.inform_all_listeners();
    }

    public void add(WarningListEntry.Type type, WarningListEntry.Source source, String string, long l, String string2) {
        this.entries.add(new WarningListEntry(type, source, string, l, string2));
        this.inform_all_listeners();
    }

    public List<WarningListEntry> entries() {
        return this.entries;
    }

    public void sort() {
        Collections.sort(this.entries, new Comparator<WarningListEntry>(){

            @Override
            public int compare(WarningListEntry warningListEntry, WarningListEntry warningListEntry2) {
                return (int)(warningListEntry2.timestamp - warningListEntry.timestamp);
            }
        });
    }

    public String toJSONString() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (WarningListEntry warningListEntry : this.entries) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(KEY_TYPE, (Object)warningListEntry.type.name());
            jSONObject.put(KEY_SOURCE, (Object)warningListEntry.source.name());
            jSONObject.put(KEY_SOURCE_DETAILS, (Object)warningListEntry.source_details);
            jSONObject.put(KEY_TIMESTAMP, warningListEntry.timestamp);
            jSONObject.put(KEY_MESSAGE, (Object)warningListEntry.message);
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(WarningsChangeListener warningsChangeListener) {
        Set<WarningsChangeListener> set = this.m_change_listeners;
        synchronized (set) {
            this.m_change_listeners.add(warningsChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeChangeListener(WarningsChangeListener warningsChangeListener) {
        Set<WarningsChangeListener> set = this.m_change_listeners;
        synchronized (set) {
            this.m_change_listeners.remove(warningsChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inform_all_listeners() {
        Set<WarningsChangeListener> set = this.m_change_listeners;
        synchronized (set) {
            for (WarningsChangeListener warningsChangeListener : this.m_change_listeners) {
                warningsChangeListener.changed(this.entries);
            }
        }
    }
}

