/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.jms.resources;

import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.jms.resources.FileFinalResourceDescr;
import de.wilke.wizepanel.jms.resources.FinalResourcePath;
import java.util.Random;

public abstract class FileFinalResourcePath
extends FinalResourcePath {
    public FileFinalResourcePath() {
        this.setFinalResourceName(this.getFileFinalResourceDescr().getFileNamePrefix() + Integer.toHexString(new Random().nextInt()));
        this.setFinalResourcePath(this.buildFinalResourcePath());
        this.setFinalResourceExtraPath(this.buildFinalResourceExtraPath());
    }

    public FileFinalResourcePath(String string) {
        if (WpFileUtils.isPath(string)) {
            this.setFinalResourcePath(string);
            this.setFinalResourceName(this.extractFinalResourceNameFromPath());
        } else {
            this.buildFinalResourceValidName(string);
            this.setFinalResourcePath(this.buildFinalResourcePath());
        }
        this.setFinalResourceExtraPath(this.buildFinalResourceExtraPath());
    }

    protected abstract FileFinalResourceDescr getFileFinalResourceDescr();

    protected abstract FileFinalResourceDescr getFileFinalResourceDescrSmall();

    @Override
    public boolean isFinalResourceNameValid() {
        return this.isFinalResourceNameValid(this.getFinalResourceName());
    }

    @Override
    public boolean isFinalResourceNameValid(String string) {
        return string.startsWith(this.getFileFinalResourceDescr().getFileNamePrefix()) || string.startsWith(this.getFileFinalResourceDescrSmall().getFileNamePrefix());
    }

    @Override
    public String buildFinalResourceValidName(String string) {
        this.setFinalResourceName((String)(this.isFinalResourceNameValid(string) ? string : this.getFileFinalResourceDescr().getFileNamePrefix() + string));
        return this.getFinalResourceName();
    }

    private String buildFinalResourcePath() {
        return this.buildFinalResourcePath(this.getFileFinalResourceDescr().getFileType(), this.getFinalResourceName(), this.getFileFinalResourceDescr().getFileNamePrefix(), this.getFileFinalResourceDescr().getFileExtension());
    }

    private String buildFinalResourceExtraPath() {
        return this.buildFinalResourcePath(this.getFileFinalResourceDescrSmall().getFileType(), this.getNameWithoutPrefix(this.getFinalResourceName()), this.getFileFinalResourceDescrSmall().getFileNamePrefix(), this.getFileFinalResourceDescrSmall().getFileExtension());
    }

    private String buildFinalResourcePath(WpFile.WpFileType wpFileType, String string, String string2, String string3) {
        Object object = "";
        if (wpFileType != null) {
            object = (String)object + new WpFile(wpFileType).getResolvedFileName() + "/";
        }
        if (!this.isFinalResourceNameValid(string)) {
            object = (String)object + string2;
        }
        object = (String)object + string;
        if (string3 != null) {
            object = (String)object + "." + string3;
        }
        return object;
    }

    private String extractFinalResourceNameFromPath() {
        String string = new WpFile(this.getFinalResourcePath()).getJavaFile().getName();
        String string2 = WpFileUtils.getBasename(string);
        return string2;
    }

    private String getNameWithoutPrefix(String string) {
        if (this.isFinalResourceNameValid(string)) {
            if (string.startsWith(this.getFileFinalResourceDescr().getFileNamePrefix())) {
                return string.substring(this.getFileFinalResourceDescr().getFileNamePrefix().length());
            }
            if (string.startsWith(this.getFileFinalResourceDescrSmall().getFileNamePrefix())) {
                return string.substring(this.getFileFinalResourceDescrSmall().getFileNamePrefix().length());
            }
        }
        return string;
    }
}

