/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.jms.session;

import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class WpSessionAttributes {
    private String id;
    private SESSION_COMMAND command = null;
    private String originator;
    private SESSION_TAG tag;
    private String info;
    private static final String JSON_KEY_ID = "id";
    private static final String JSON_KEY_COMMAND = "command";
    private static final String JSON_KEY_ORIGIN = "origin";
    private static final String JSON_KEY_TAG = "tag";
    private static final String JSON_KEY_INFO = "info";

    public WpSessionAttributes() {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
        this.command = SESSION_COMMAND.CREATE;
        this.originator = SESSION_ORIGINATOR.EXTERN.name();
        this.tag = SESSION_TAG.IDE;
        this.info = "";
    }

    public WpSessionAttributes(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has(JSON_KEY_ID)) {
            this.id = jSONObject.getString(JSON_KEY_ID);
        }
        if (jSONObject.has(JSON_KEY_COMMAND)) {
            this.command = SESSION_COMMAND.valueOf(jSONObject.getString(JSON_KEY_COMMAND));
        }
        if (jSONObject.has(JSON_KEY_ORIGIN)) {
            this.originator = jSONObject.getString(JSON_KEY_ORIGIN);
        }
        if (jSONObject.has(JSON_KEY_TAG)) {
            this.tag = SESSION_TAG.valueOf(jSONObject.getString(JSON_KEY_TAG));
        }
        if (jSONObject.has(JSON_KEY_INFO)) {
            this.info = jSONObject.getString(JSON_KEY_INFO);
        }
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.id != null) {
            jSONObject.put(JSON_KEY_ID, (Object)this.id);
        }
        if (this.command != null) {
            jSONObject.put(JSON_KEY_COMMAND, (Object)this.command.name());
        }
        if (this.originator != null) {
            jSONObject.put(JSON_KEY_ORIGIN, (Object)this.originator);
        }
        if (this.tag != null) {
            jSONObject.put(JSON_KEY_TAG, (Object)this.tag.name());
        }
        if (this.info != null) {
            jSONObject.put(JSON_KEY_INFO, (Object)this.info);
        }
        return jSONObject;
    }

    public WpSessionAttributes(SESSION_TAG sESSION_TAG) {
        this();
        this.tag = sESSION_TAG;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.command == null ? 0 : this.command.hashCode());
        n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
        n = 31 * n + (this.info == null ? 0 : this.info.hashCode());
        n = 31 * n + (this.originator == null ? 0 : this.originator.hashCode());
        n = 31 * n + (this.tag == null ? 0 : this.tag.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        WpSessionAttributes wpSessionAttributes = (WpSessionAttributes)object;
        if (this.command != wpSessionAttributes.command) {
            return false;
        }
        if (this.id == null ? wpSessionAttributes.id != null : !this.id.equals(wpSessionAttributes.id)) {
            return false;
        }
        if (this.info == null ? wpSessionAttributes.info != null : !this.info.equals(wpSessionAttributes.info)) {
            return false;
        }
        if (this.originator == null ? wpSessionAttributes.originator != null : !this.originator.equals(wpSessionAttributes.originator)) {
            return false;
        }
        return this.tag == wpSessionAttributes.tag;
    }

    public String getID() {
        return this.id;
    }

    public WpSessionAttributes setID(String string) {
        this.id = string;
        return this;
    }

    public SESSION_COMMAND getCommand() {
        return this.command;
    }

    public void setCommand(SESSION_COMMAND sESSION_COMMAND) {
        this.command = sESSION_COMMAND;
    }

    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator(SESSION_ORIGINATOR sESSION_ORIGINATOR) {
        this.originator = sESSION_ORIGINATOR.name();
    }

    public void setOriginator(String string) {
        this.originator = string;
    }

    public SESSION_TAG getTag() {
        return this.tag;
    }

    public void setTag(SESSION_TAG sESSION_TAG) {
        this.tag = sESSION_TAG;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public boolean isStudio() {
        return this.tag == SESSION_TAG.IDE;
    }

    public static enum SESSION_TAG {
        NONE,
        IDE,
        EXTERN;

    }

    public static enum SESSION_COMMAND {
        NONE,
        CREATE,
        DELETE;

    }

    public static enum SESSION_ORIGINATOR {
        EXTERN,
        STUDIO,
        SERVER,
        ADAPTER;

    }
}

