/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;

public class MouseHandle {
    private static final int MOUSE_HANDLE_SIZE = 8;
    private int x = 0;
    private int y = 0;
    private Cursor def_cursor = Cursor.getPredefinedCursor(13);
    private Cursor cur_cursor = Cursor.getPredefinedCursor(13);

    public MouseHandle() {
    }

    public MouseHandle(Cursor cursor) {
        this.def_cursor = cursor;
        this.cur_cursor = cursor;
    }

    public MouseHandle(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public MouseHandle(int n, int n2, Cursor cursor) {
        this.x = n;
        this.y = n2;
        this.def_cursor = cursor;
        this.cur_cursor = cursor;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getX() {
        return this.x;
    }

    public void setCursor(Cursor cursor) {
        this.cur_cursor = cursor;
    }

    public void restoreCursor() {
        this.cur_cursor = this.def_cursor;
    }

    public Cursor cursor() {
        return this.cur_cursor;
    }

    public void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Point getPosition() {
        return new Point(this.x, this.y);
    }

    public void shift(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public void draw(Graphics2D graphics2D, double d, Color color) {
        int n = (int)((double)this.x * d) - 4;
        int n2 = (int)((double)this.y * d) - 4;
        graphics2D.setPaint(color);
        graphics2D.fillRect(n, n2, 8, 8);
        graphics2D.setPaint(Color.BLUE);
        graphics2D.drawRect(n, n2, 8, 8);
    }

    public boolean contains(Point point) {
        return point.x >= this.x - 4 && point.x <= this.x + 4 && point.y >= this.y - 4 && point.y <= this.y + 4;
    }
}

