/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates;

import de.wilke.wizepanel.core.WpDisplayUtils;
import de.wilke.wizepanel.core.WpGraphicsUtils;
import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.displays.Display;
import de.wilke.wizepanel.templates.MyZip;
import de.wilke.wizepanel.templates.PlaceholderDetails;
import de.wilke.wizepanel.templates.TemplateListener;
import de.wilke.wizepanel.templates.elements.TemplateElement;
import de.wilke.wizepanel.templates.elements.TemplateElementEllipse;
import de.wilke.wizepanel.templates.elements.TemplateElementGraphics;
import de.wilke.wizepanel.templates.elements.TemplateElementLine;
import de.wilke.wizepanel.templates.elements.TemplateElementQR;
import de.wilke.wizepanel.templates.elements.TemplateElementRect;
import de.wilke.wizepanel.templates.elements.TemplateElementText;
import de.wilke.wizepanel.templates.elements.TemplateElementTimetable;
import de.wilke.wizepanel.templates.elements.TemplateElementsListener;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Template
implements Printable {
    public static final String FILENAME_EXT = "zip";
    private static final String[] m_image_ext = new String[]{"png", "jpg", "gif", "bmp"};
    private static final String XML_TEMPLATE = "wp_template";
    private static final String XML_PROPERTIES = "properties";
    private static final String XML_PROPERTY = "property";
    private static final String XML_ELEMENT = "element";
    private static final String XML_LAYER = "layer";
    public static final String XML_PLACEHOLDER = "placeholder";
    private static final String XML_VERSION = "version";
    public static final String TOOL_SELECT = "tool.select";
    public static final String TOOL_RECT = "tool.rect";
    public static final String TOOL_ELLIPSE = "tool.ellipse";
    public static final String TOOL_LINE = "tool.line";
    public static final String TOOL_TEXT = "tool.text";
    public static final String TOOL_GRAPHICS = "tool.graphics";
    public static final String TOOL_QR = "tool.qr";
    public static final String TOOL_TIMETABLE = "tool.timetable";
    public static final String MORE_COLORS = " ... ";
    private Display m_type;
    private boolean m_modified = false;
    private TemplateElementsListener m_app = null;
    private final MyZip m_zip = new MyZip();
    private final Map<String, String> m_properties;
    private final LinkedList<TemplateElement> m_elements = new LinkedList();
    private final LinkedList<TemplateElement> m_selected_elements = new LinkedList();
    private final Set<TemplateListener> m_listeners = new HashSet<TemplateListener>();
    private String m_last_error;
    private TimeZone time_zone = null;
    private int hashcode = 0;

    public Template() {
        this.m_properties = new HashMap<String, String>();
        this.m_properties.put("title", "");
        this.m_properties.put("desc", "");
        this.m_properties.put("type", null);
        this.m_properties.put("bg_color", "#FFFFFF");
        this.m_properties.put("grid_size", "10");
        this.m_properties.put("snap_to_grid", "false");
        this.m_properties.put("default", "false");
        this.setType(WpDisplayUtils.getDisplay("320x240x1xWizePanel"));
    }

    public boolean isModified() {
        return this.m_modified;
    }

    public void setModified(boolean bl) {
        this.m_modified = bl;
        this.informTemplateListeners(TemplateListener.TemplateEvent.MODIFIED);
    }

    public void setTitle(String string) {
        this.m_modified = true;
        this.m_properties.put("title", string);
    }

    public void setIsDefault(String string) {
        this.m_modified = true;
        this.m_properties.put("default", string);
    }

    public String title() {
        return this.m_properties.get("title");
    }

    public String isDefault() {
        return this.m_properties.containsKey("default") ? this.m_properties.get("default") : "false";
    }

    public void setDescription(String string) {
        this.m_modified = true;
        this.m_properties.put("desc", string);
    }

    public String description() {
        return this.m_properties.get("desc");
    }

    public String type() {
        return this.m_properties.get("type");
    }

    public Display getDisplay() {
        return this.m_type;
    }

    public void setType(Display display) {
        this.m_type = display;
        this.m_properties.put("type", display.toString());
        for (TemplateElement templateElement : this.m_elements) {
            templateElement.rebuild();
        }
    }

    public void setTransparent(boolean bl) {
        if (this.m_type.canBeTransparent() && bl) {
            this.setBackgroundColor(null);
        } else {
            this.setBackgroundColor(this.m_type.defaultBackground());
        }
    }

    public void setBackgroundColor(Color color) {
        this.m_modified = true;
        this.m_properties.put("bg_color", WpTemplateUtils.color2str(color));
    }

    public Color backgroundColor() {
        return WpTemplateUtils.str2color(this.m_properties.get("bg_color"));
    }

    public void setGridSize(int n) {
        this.m_modified = true;
        this.m_properties.put("grid_size", Integer.toString(n));
    }

    public int gridSize() {
        return Integer.parseInt(this.m_properties.get("grid_size"));
    }

    public void setSnapToGrind(boolean bl) {
        this.m_modified = true;
        this.m_properties.put("snap_to_grid", WpUtils.bool2str(bl));
    }

    public boolean snapToGrid() {
        return WpUtils.str2bool(this.m_properties.get("snap_to_grid"));
    }

    public String filename() {
        return this.m_zip.getFilename();
    }

    public String getLastError() {
        return this.m_last_error;
    }

    public boolean createNew(String string, String string2, String string3, Color color, String string4) {
        this.m_zip.clear();
        return this.create(string, string2, string3, color, string4);
    }

    public boolean create(String string, String string2, String string3, Color color, String string4) {
        this.m_type = WpDisplayUtils.getDisplay(string3);
        if (this.m_type == null) {
            return false;
        }
        this.setTitle(string);
        this.setDescription(string2);
        this.setType(this.m_type);
        this.setBackgroundColor(color);
        this.setIsDefault(string4);
        this.m_modified = false;
        this.m_selected_elements.clear();
        this.m_elements.clear();
        this.informTemplateListeners(TemplateListener.TemplateEvent.NEW_TEMPLATE);
        return true;
    }

    public BufferedImage getImage(String string) {
        return this.m_zip.getImage(string);
    }

    public String addImage(String string) throws Exception {
        return this.m_zip.addImage(string);
    }

    public BufferedImage image_rgb2tpl(BufferedImage bufferedImage) {
        switch (this.m_type.getColorDepth()) {
            case 1: {
                return WpGraphicsUtils.to1bit(bufferedImage, this.backgroundColor());
            }
            case 4: {
                return WpGraphicsUtils.to4bitGrayscale(bufferedImage, this.backgroundColor());
            }
        }
        return bufferedImage;
    }

    public void removeImageOnSave(String string) {
        this.m_zip.removeImageOnSave(string);
    }

    public boolean open(String string) {
        if (!this.m_zip.open(string)) {
            return false;
        }
        this.hashcode = (int)new File(string).lastModified();
        try {
            Object object;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            String string2 = this.m_zip.getTemplate();
            if (string2 == null) {
                this.m_zip.clear();
                return false;
            }
            Document document = documentBuilder.parse(new InputSource(new StringReader(string2)));
            document.getDocumentElement().normalize();
            Element element = (Element)document.getElementsByTagName(XML_PROPERTIES).item(0);
            NodeList nodeList = document.getElementsByTagName(XML_PROPERTY);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                element = (Element)object;
                this.m_properties.put(element.getAttribute("name"), element.getAttribute("value"));
            }
            String string3 = this.m_properties.get("title");
            object = this.m_properties.get("desc");
            String string4 = this.m_properties.get("type");
            String string5 = this.m_properties.get("default");
            Color color = WpTemplateUtils.str2color(this.m_properties.get("bg_color"));
            if (!this.create(string3, (String)object, string4, color, string5)) {
                this.m_last_error = "err_invalid_tpl_format";
                this.m_zip.clear();
                return false;
            }
            NodeList nodeList2 = document.getElementsByTagName(XML_ELEMENT);
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                element = (Element)node;
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string6 = namedNodeMap.removeNamedItem("name").getNodeValue();
                string4 = namedNodeMap.removeNamedItem("type").getNodeValue();
                int n = Integer.parseInt(namedNodeMap.removeNamedItem(XML_LAYER).getNodeValue());
                String string7 = namedNodeMap.removeNamedItem(XML_PLACEHOLDER).getNodeValue();
                TemplateElement templateElement = this.createNewElement(string4, string6);
                if (templateElement == null) continue;
                templateElement.setName(string6);
                templateElement.setLayer(n);
                templateElement.setPlaceholderName(string7);
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    node = namedNodeMap.item(j);
                    if (templateElement.setAttribute(node.getNodeName(), node.getNodeValue())) continue;
                    System.err.println("element [" + templateElement.name() + "] could not set attribute [" + node.getNodeName() + "] to value [" + node.getNodeValue() + "]");
                }
                this.check_datetime_placeholder(templateElement);
                templateElement.rebuild();
                this.addElement(templateElement, false, false, false);
            }
        }
        catch (Exception exception) {
            this.m_last_error = exception.getMessage();
            this.m_zip.clear();
            return false;
        }
        this.align_layers();
        this.m_modified = false;
        this.informTemplateListeners(TemplateListener.TemplateEvent.NEW_TEMPLATE);
        return true;
    }

    public int getWidth() {
        return this.m_type.getWidth();
    }

    public int getHeight() {
        return this.m_type.getHeight();
    }

    private void check_datetime_placeholder(TemplateElement templateElement) {
        if (templateElement.getPlaceholderName().matches("(\\d+#)?DATETIME(\\[\\d+\\])?(\\[\\d+\\])?")) {
            if (templateElement.getPlaceholderFormat().isEmpty()) {
                templateElement.setPlaceholderFormat("{date:HH:mm} - {date:HH:mm}");
            } else if (templateElement.getPlaceholderFormat().startsWith("date:")) {
                templateElement.setPlaceholderFormat("{" + templateElement.getPlaceholderFormat() + "} - {" + templateElement.getPlaceholderFormat() + "}");
            } else if (templateElement.getPlaceholderFormat().indexOf(123) == templateElement.getPlaceholderFormat().lastIndexOf(123)) {
                templateElement.setPlaceholderFormat(templateElement.getPlaceholderFormat() + " - " + templateElement.getPlaceholderFormat());
            }
        }
    }

    public boolean writeTo(String string) {
        this.m_zip.open(string);
        boolean bl = this.m_zip.write(this);
        if (bl) {
            this.informTemplateListeners(TemplateListener.TemplateEvent.SAVED);
        }
        return bl;
    }

    public void getZipTemplate(ZipOutputStream zipOutputStream) {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return;
        }
        Document document = documentBuilder.newDocument();
        Element element = document.createElement(XML_TEMPLATE);
        element.setAttribute(XML_VERSION, "0.0.1");
        document.appendChild(element);
        Element element2 = document.createElement(XML_PROPERTIES);
        for (String object : this.m_properties.keySet()) {
            Element transformerFactory = document.createElement(XML_PROPERTY);
            transformerFactory.setAttribute("name", object);
            transformerFactory.setAttribute("value", this.m_properties.get(object));
            element2.appendChild(transformerFactory);
        }
        element.appendChild(element2);
        for (int exception = 0; exception < this.m_elements.size(); ++exception) {
            HashMap<String, String> hashMap = this.m_elements.get(exception).attributes();
            Element element4 = document.createElement(XML_ELEMENT);
            for (Object object : hashMap.keySet()) {
                element4.setAttribute((String)object, hashMap.get(object));
            }
            element4.setAttribute(XML_PLACEHOLDER, this.m_elements.get(exception).getPlaceholderName());
            element.appendChild(element4);
        }
        try {
            Object object;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            object = new DOMSource(document);
            StreamResult streamResult = new StreamResult(zipOutputStream);
            transformer.transform((Source)object, streamResult);
        }
        catch (Exception exception) {
            this.m_last_error = exception.getMessage();
            System.out.println("Template::writeTo()");
            return;
        }
        this.m_modified = false;
    }

    public void setPlaceholder(String string, String string2) {
        for (TemplateElement templateElement : this.m_elements) {
            if (templateElement.getPlaceholderName().isEmpty() || !templateElement.getPlaceholderName().equalsIgnoreCase(string)) continue;
            if (string2 == null || string2.isEmpty()) {
                if (templateElement.isPlaceholderShowDefaultIfEmpty()) continue;
                templateElement.setPlaceholderValue("");
                continue;
            }
            templateElement.setPlaceholderValue(string2);
        }
    }

    public List<PlaceholderDetails> getPlaceholders() {
        LinkedList<PlaceholderDetails> linkedList = new LinkedList<PlaceholderDetails>();
        for (TemplateElement templateElement : this.m_elements) {
            if (templateElement.getPlaceholderName().length() == 0) continue;
            linkedList.add(new PlaceholderDetails(templateElement.getPlaceholderName(), templateElement.getPlaceholderValue(), templateElement.getPlaceholderFormat()));
        }
        return linkedList;
    }

    public String getPlaceholderType(String string) {
        for (TemplateElement templateElement : this.m_elements) {
            if (!templateElement.getPlaceholderName().equals(string)) continue;
            return templateElement.type();
        }
        return null;
    }

    public TemplateElement createNewElement(String string, String string2) {
        TemplateElement templateElement = null;
        if (string.equals(TOOL_RECT)) {
            templateElement = new TemplateElementRect(this);
        } else if (string.equals(TOOL_LINE)) {
            templateElement = new TemplateElementLine(this);
        } else if (string.equals(TOOL_ELLIPSE)) {
            templateElement = new TemplateElementEllipse(this);
        } else if (string.equals(TOOL_TEXT)) {
            templateElement = new TemplateElementText(this);
        } else if (string.equals(TOOL_GRAPHICS)) {
            templateElement = new TemplateElementGraphics(this);
        } else if (string.equals(TOOL_QR)) {
            templateElement = new TemplateElementQR(this);
        } else if (string.equals(TOOL_TIMETABLE)) {
            templateElement = new TemplateElementTimetable(this);
        } else {
            System.err.println("TemplateElement.createNewElement(type => " + string + ", name => " + string2 + ") unknown type");
            return null;
        }
        this.m_modified = true;
        templateElement.setLayer(this.m_elements.size());
        templateElement.setName(string2);
        return templateElement;
    }

    public TemplateElement cloneElement(TemplateElement templateElement) {
        TemplateElement templateElement2 = this.createNewElement(templateElement.type(), templateElement.name());
        HashMap<String, String> hashMap = templateElement.attributes();
        for (String string : hashMap.keySet()) {
            System.out.println(string + " : " + hashMap.get(string));
            templateElement2.setAttribute(string, hashMap.get(string));
        }
        templateElement2.normalize();
        return templateElement2;
    }

    public int elements() {
        return this.m_elements.size();
    }

    public void addElement(TemplateElement templateElement, boolean bl, boolean bl2, boolean bl3) {
        this.m_modified = true;
        templateElement.setName(this.make_name_unique(templateElement.type()));
        templateElement.setLayer(this.m_elements.size() + 1);
        this.m_elements.add(templateElement);
        if (bl3) {
            this.selectElement(templateElement);
        }
        if (bl && this.m_app != null) {
            this.m_app.elementAdded(this, templateElement);
        }
        if (bl2) {
            this.informTemplateListeners(TemplateListener.TemplateEvent.NEW_SELECTED);
        }
    }

    public void addElements(LinkedList<TemplateElement> linkedList, Point point, boolean bl) {
        this.m_modified = true;
        LinkedList<TemplateElement> linkedList2 = new LinkedList<TemplateElement>();
        this.m_selected_elements.clear();
        if (bl && this.m_app != null) {
            for (TemplateElement templateElement : linkedList) {
                TemplateElement templateElement2 = this.cloneElement(templateElement);
                templateElement2.setName(this.make_name_unique(templateElement.type()));
                templateElement2.shift(point.x, point.y);
                templateElement2.setLayer(this.m_elements.size() + 1);
                templateElement2.rebuild();
                this.m_elements.add(templateElement2);
                this.m_selected_elements.add(templateElement2);
                linkedList2.add(templateElement2);
            }
        }
        if (linkedList2.size() != 0) {
            this.m_app.elementsAdded(linkedList2);
        }
        this.informTemplateListeners(TemplateListener.TemplateEvent.NEW_SELECTED);
    }

    public void removeElements(LinkedList<TemplateElement> linkedList, boolean bl) {
        this.m_modified = true;
        LinkedList<TemplateElement> linkedList2 = new LinkedList<TemplateElement>();
        if (bl && this.m_app != null) {
            for (TemplateElement templateElement : linkedList) {
                linkedList2.add(templateElement);
            }
        }
        this.m_elements.removeAll(linkedList);
        this.m_selected_elements.removeAll(linkedList);
        if (linkedList2.size() != 0) {
            this.m_app.elementsDeleted(linkedList2);
        }
        this.informTemplateListeners(TemplateListener.TemplateEvent.NEW_SELECTED);
    }

    public void removeElement(TemplateElement templateElement, boolean bl) {
        LinkedList<TemplateElement> linkedList = new LinkedList<TemplateElement>();
        linkedList.add(templateElement);
        this.removeElements(linkedList, bl);
    }

    public TemplateElement getElementAt(int n) {
        return this.m_elements.get(n);
    }

    public void selectNextElement() {
        if (this.m_elements.size() == 0 || this.m_selected_elements.size() == 0) {
            return;
        }
        if (this.m_selected_elements.size() == 1) {
            TemplateElement templateElement = (TemplateElement)this.m_selected_elements.iterator().next();
            int n = this.m_elements.indexOf(templateElement);
            n = (n + 1) % this.m_elements.size();
            this.selectElement(this.m_elements.get(n));
        } else {
            this.setReferenceElement(this.m_selected_elements.get(0));
        }
        this.informTemplateListeners(TemplateListener.TemplateEvent.NEW_SELECTED);
    }

    public void setReferenceElement(TemplateElement templateElement) {
        this.m_selected_elements.remove(templateElement);
        this.m_selected_elements.add(templateElement);
        this.informTemplateListeners(TemplateListener.TemplateEvent.NEW_SELECTED);
    }

    public TemplateElement getReferenceElement() {
        if (this.m_selected_elements.size() > 0) {
            return this.m_selected_elements.get(this.m_selected_elements.size() - 1);
        }
        return null;
    }

    public void selectElement(TemplateElement templateElement) {
        if (templateElement != null) {
            if (!this.m_elements.contains(templateElement)) {
                return;
            }
            if (templateElement == this.getSelectedElement()) {
                return;
            }
        }
        this.m_selected_elements.clear();
        if (templateElement != null) {
            this.m_selected_elements.add(templateElement);
        }
        this.informTemplateListeners(TemplateListener.TemplateEvent.NEW_SELECTED);
    }

    public boolean isElementSelected(TemplateElement templateElement) {
        return this.m_selected_elements.contains(templateElement);
    }

    public void toggleSelection(TemplateElement templateElement) {
        if (this.m_selected_elements.contains(templateElement)) {
            this.m_selected_elements.remove(templateElement);
        } else {
            this.m_selected_elements.add(templateElement);
        }
        this.informTemplateListeners(TemplateListener.TemplateEvent.NEW_SELECTED);
    }

    public void selectAll() {
        if (this.m_selected_elements.size() != this.m_elements.size()) {
            this.m_selected_elements.clear();
            this.m_selected_elements.addAll(this.m_elements);
            this.informTemplateListeners(TemplateListener.TemplateEvent.NEW_SELECTED);
        }
    }

    public void clearSelection() {
        if (this.m_selected_elements.size() != 0) {
            this.m_selected_elements.clear();
            this.informTemplateListeners(TemplateListener.TemplateEvent.NEW_SELECTED);
        }
    }

    public TemplateElement getElement(Rectangle rectangle) {
        for (int i = this.m_elements.size() - 1; i >= 0; --i) {
            if (!this.m_elements.get(i).intersects(rectangle)) continue;
            return this.m_elements.get(i);
        }
        return null;
    }

    public LinkedList<TemplateElement> getElements(Rectangle rectangle) {
        LinkedList<TemplateElement> linkedList = new LinkedList<TemplateElement>();
        for (TemplateElement templateElement : this.m_elements) {
            if (!templateElement.intersects(rectangle)) continue;
            linkedList.add(templateElement);
        }
        return linkedList;
    }

    public TemplateElement getElementByPlaceholder(String string) {
        for (int i = 0; i < this.m_elements.size(); ++i) {
            if (!this.m_elements.get(i).getPlaceholderName().equals(string)) continue;
            return this.m_elements.get(i);
        }
        return null;
    }

    public TemplateElement getSelectedElement() {
        if (this.m_selected_elements.size() == 1) {
            return (TemplateElement)this.m_selected_elements.iterator().next();
        }
        return null;
    }

    public LinkedList<TemplateElement> getSelectedElements() {
        return this.m_selected_elements;
    }

    public boolean allSelectedMoveable() {
        for (TemplateElement templateElement : this.m_selected_elements) {
            if (templateElement.isMoveable()) continue;
            return false;
        }
        return true;
    }

    private String make_name_unique(String string) {
        Object object = string;
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            boolean bl = false;
            for (TemplateElement templateElement : this.m_elements) {
                if (!templateElement.name().equals(object)) continue;
                bl = true;
                break;
            }
            if (!bl) break;
            object = string + i;
        }
        return object;
    }

    public void setLayers(HashMap<Integer, TemplateElement> hashMap) {
        for (int n : hashMap.keySet()) {
            TemplateElement templateElement = hashMap.get(n);
            this.m_elements.remove(templateElement);
            this.m_elements.add(templateElement);
        }
        this.align_layers();
        this.informTemplateListeners(TemplateListener.TemplateEvent.MODIFIED);
    }

    public HashMap<Integer, TemplateElement> getLayers() {
        HashMap<Integer, TemplateElement> hashMap = new HashMap<Integer, TemplateElement>();
        for (TemplateElement templateElement : this.m_elements) {
            hashMap.put(templateElement.layer(), templateElement);
        }
        return hashMap;
    }

    public void layerTop() {
        HashMap<Integer, TemplateElement> hashMap = new HashMap<Integer, TemplateElement>();
        for (TemplateElement templateElement : this.m_selected_elements) {
            hashMap.put(templateElement.layer(), templateElement);
        }
        HashMap<Integer, TemplateElement> hashMap2 = this.getLayers();
        int n = this.m_elements.size();
        for (int i = 0; i < this.m_selected_elements.size(); ++i) {
            TemplateElement templateElement = this.m_selected_elements.get(i);
            this.m_elements.remove(templateElement);
            this.m_elements.add(n - 1, templateElement);
        }
        this.align_layers();
        this.m_app.elementsLayersChanged(hashMap2);
    }

    public void layerUp() {
        HashMap<Integer, TemplateElement> hashMap = this.getLayers();
        for (TemplateElement templateElement : this.m_selected_elements) {
            int n = this.m_elements.indexOf(templateElement) + 1;
            if (n >= this.m_elements.size()) {
                n = this.m_elements.size() - 1;
            }
            this.m_elements.remove(templateElement);
            this.m_elements.add(n, templateElement);
        }
        this.align_layers();
        this.m_app.elementsLayersChanged(hashMap);
    }

    public void layerDown() {
        HashMap<Integer, TemplateElement> hashMap = this.getLayers();
        for (TemplateElement templateElement : this.m_selected_elements) {
            int n = this.m_elements.indexOf(templateElement) - 1;
            if (n < 0) {
                n = 0;
            }
            this.m_elements.remove(templateElement);
            this.m_elements.add(n, templateElement);
        }
        this.align_layers();
        this.m_app.elementsLayersChanged(hashMap);
    }

    public void layerBottom() {
        HashMap<Integer, TemplateElement> hashMap = new HashMap<Integer, TemplateElement>();
        for (TemplateElement templateElement : this.m_selected_elements) {
            hashMap.put(templateElement.layer(), templateElement);
        }
        HashMap<Integer, TemplateElement> hashMap2 = this.getLayers();
        int n = 0;
        for (int i = this.m_selected_elements.size() - 1; i >= 0; --i) {
            TemplateElement templateElement = this.m_selected_elements.get(i);
            this.m_elements.remove(templateElement);
            this.m_elements.add(n++, templateElement);
        }
        this.align_layers();
        this.m_app.elementsLayersChanged(hashMap2);
    }

    private void align_layers() {
        for (int i = 0; i < this.m_elements.size(); ++i) {
            this.m_elements.get(i).setLayer(i + 1);
        }
    }

    public void print_elements_stack() {
        System.out.println("Elements from Bottom to Top");
        for (int i = 0; i < this.m_elements.size(); ++i) {
            TemplateElement templateElement = this.m_elements.get(i);
            System.out.println("  #" + i + "\tlayer: " + templateElement.layer() + "\tname: " + templateElement.name());
        }
    }

    public void addTemplateListener(TemplateListener templateListener) {
        this.m_listeners.add(templateListener);
    }

    public void removeTemplateListener(TemplateListener templateListener) {
        this.m_listeners.remove(templateListener);
    }

    public void informTemplateListeners(TemplateListener.TemplateEvent templateEvent) {
        for (TemplateListener templateListener : this.m_listeners) {
            templateListener.templateModified(this, templateEvent);
        }
    }

    public void setElementsListener(TemplateElementsListener templateElementsListener) {
        this.m_app = templateElementsListener;
    }

    public BufferedImage exportToImage(boolean bl) {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return null;
        }
        int n = 2;
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.backgroundColor() != null) {
            graphics2D.setColor(this.backgroundColor());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        for (int i = 0; i < this.m_elements.size(); ++i) {
            if (bl) {
                this.m_elements.get(i).setPlaceholderValue("");
            }
            if (this.m_elements.get(i).doHideElement()) continue;
            this.m_elements.get(i).draw(graphics2D, false, false);
        }
        return this.image_rgb2tpl(bufferedImage);
    }

    public boolean writeToImage(String string, boolean bl) {
        boolean bl2;
        if (string.length() < 4) {
            return false;
        }
        String string2 = string.substring(string.length() - 3);
        if (!Template.isValidImageType(string2)) {
            this.m_last_error = "err_invalid_filename";
            return false;
        }
        File file = new File(string);
        try {
            if (!file.canWrite() && !file.createNewFile()) {
                this.m_last_error = "err_not_writeable";
                return false;
            }
        }
        catch (IOException iOException) {
            this.m_last_error = iOException.getMessage();
            return false;
        }
        BufferedImage bufferedImage = this.exportToImage(bl);
        if (bufferedImage == null) {
            this.m_last_error = "exportToImage() failed.";
            return false;
        }
        try {
            bl2 = ImageIO.write((RenderedImage)bufferedImage, string2, file);
        }
        catch (IOException iOException) {
            this.m_last_error = iOException.getMessage();
            bl2 = false;
        }
        return bl2;
    }

    public static boolean isValidImageType(String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : m_image_ext) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static String[] getImageExtentions() {
        return m_image_ext;
    }

    public static String color2str(Color color) {
        return String.format("#%H%H%H", color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2 = 1200;
        if (n == 0) {
            double d;
            int n3 = this.getHeight();
            int n4 = n2;
            if (pageFormat.getImageableWidth() < (double)n3) {
                d = pageFormat.getImageableWidth() / (double)n3;
                n3 = (int)pageFormat.getImageableWidth();
                n4 = (int)((double)n4 * d);
            }
            if (pageFormat.getImageableHeight() < (double)n4) {
                d = pageFormat.getImageableHeight() / (double)n4;
                n4 = (int)pageFormat.getImageableHeight();
                n3 = (int)((double)n3 * d);
            }
            graphics.drawImage(this.exportToImage(true), (int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), n3, n4, null);
            return 0;
        }
        return 1;
    }

    public Vector<String> getCommonColors(String string) {
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        switch (this.m_type.getColorDepth()) {
            case 1: {
                vector.add("#FFFFFF");
                vector.add("#000000");
                bl = false;
                break;
            }
            case 4: {
                for (String string2 : WpGraphicsUtils.grayColors()) {
                    vector.add(string2);
                }
                bl = false;
                break;
            }
            case 8: {
                vector.add("#FFFFFF");
                vector.add("#cccccc");
                vector.add("#999999");
                vector.add("#666666");
                vector.add("#333333");
                vector.add("#000000");
                bl = true;
                break;
            }
            default: {
                vector.add("#FF0000");
                vector.add("#00FF00");
                vector.add("#0000FF");
                bl = true;
            }
        }
        if (!vector.contains(string)) {
            vector.add(0, string);
        }
        if (bl) {
            vector.add(MORE_COLORS);
        }
        return vector;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.time_zone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.time_zone;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

