/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates;

import de.wilke.wizepanel.core.WpDisplayUtils;
import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.core.displays.Display;
import de.wilke.wizepanel.templates.MyZip;
import java.awt.Color;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TemplateInfo {
    public static final String XML_TITLE = "title";
    public static final String XML_TYPE = "type";
    public static final String XML_NAME = "name";
    public static final String XML_VALUE = "value";
    public static final String XML_BG_COLOR = "bg_color";
    public static final String XML_DESC = "desc";
    public static final String XML_GRID_SIZE = "grid_size";
    public static final String XML_SNAP_TO_GRID = "snap_to_grid";
    public static final String XML_DEFAULT = "default";
    public static final String JSON_KEY_PLACEHOLDERS = "ph";
    public static final String JSON_KEY_PROPERTIES = "props";
    public static final String JSON_KEY_TYPE = "type";
    private final Map<String, String> m_placeholders = new HashMap<String, String>();
    private final Map<String, String> m_properties = new HashMap<String, String>();
    private Display m_type;
    private int nr_events = 2;
    private int nr_sources = 1;
    private final String name;

    public TemplateInfo(String string, JSONObject jSONObject) throws Exception {
        JSONObject jSONObject2;
        this.name = string;
        if (jSONObject.has(JSON_KEY_PLACEHOLDERS) && (jSONObject2 = jSONObject.getJSONObject(JSON_KEY_PLACEHOLDERS)).length() != 0) {
            for (String string2 : JSONObject.getNames((JSONObject)jSONObject2)) {
                this.m_placeholders.put(string2, jSONObject2.getString(string2));
            }
            this.update_nr_events();
        }
        if (jSONObject.has(JSON_KEY_PROPERTIES) && (jSONObject2 = jSONObject.getJSONObject(JSON_KEY_PROPERTIES)).length() != 0) {
            for (String string2 : JSONObject.getNames((JSONObject)jSONObject2)) {
                this.m_properties.put(string2, jSONObject2.getString(string2));
            }
        }
        this.m_type = WpDisplayUtils.getDisplay(this.m_properties.get("type"));
        if (this.m_type == null) {
            throw new Exception("Could not parse type: " + this.m_properties.get("type"));
        }
    }

    public int numberOfEvents() {
        return this.nr_events;
    }

    public int numberOfSources() {
        return this.nr_sources;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String object2 : this.m_placeholders.keySet()) {
            jSONObject.put(object2, (Object)this.m_placeholders.get(object2));
        }
        JSONObject jSONObject2 = new JSONObject();
        for (String string : this.m_properties.keySet()) {
            jSONObject2.put(string, (Object)this.m_properties.get(string));
        }
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put(JSON_KEY_PLACEHOLDERS, (Object)jSONObject);
        jSONObject3.put(JSON_KEY_PROPERTIES, (Object)jSONObject2);
        return jSONObject3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateInfo(String string) throws Exception {
        DocumentBuilder documentBuilder;
        this.name = string;
        MyZip myZip = new MyZip();
        if (!myZip.open(string)) {
            throw new Exception("Could not open file");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            myZip.clear();
            throw parserConfigurationException;
        }
        try {
            Object object;
            String string2 = myZip.getTemplate();
            if (string2 == null) {
                myZip.clear();
                throw new Exception("No template description");
            }
            Document document = documentBuilder.parse(new InputSource(new StringReader(string2)));
            document.getDocumentElement().normalize();
            Element element = (Element)document.getElementsByTagName("properties").item(0);
            NodeList nodeList = document.getElementsByTagName("property");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                element = (Element)object;
                this.m_properties.put(element.getAttribute(XML_NAME), element.getAttribute(XML_VALUE));
            }
            String string3 = this.m_properties.containsKey(XML_DEFAULT) ? this.m_properties.get(XML_DEFAULT) : "false";
            object = this.m_properties.get(XML_TITLE);
            String string4 = this.m_properties.get(XML_DESC);
            String string5 = this.m_properties.get("type");
            Color color = WpTemplateUtils.str2color(this.m_properties.get(XML_BG_COLOR));
            this.create((String)object, string4, string5, color, string3);
            NodeList nodeList2 = document.getElementsByTagName("element");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                element = (Element)node;
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string6 = namedNodeMap.removeNamedItem(XML_NAME).getNodeValue();
                String string7 = namedNodeMap.removeNamedItem("placeholder").getNodeValue();
                if (string6.isEmpty()) continue;
                this.m_placeholders.put(string6, string7);
            }
        }
        finally {
            myZip.clear();
        }
        this.update_nr_events();
    }

    private void create(String string, String string2, String string3, Color color, String string4) throws Exception {
        this.m_type = WpDisplayUtils.getDisplay(string3);
        if (this.m_type == null) {
            throw new Exception("Could not parse type: " + string3);
        }
        this.m_properties.put(XML_DEFAULT, string4);
        this.m_properties.put(XML_TITLE, string);
        this.m_properties.put(XML_DESC, string2);
        this.m_properties.put("type", this.m_type.toString());
        this.m_properties.put(XML_BG_COLOR, WpTemplateUtils.color2str(color));
    }

    public Display display() {
        return this.m_type;
    }

    public Map<String, String> getPlaceholders() {
        return this.m_placeholders;
    }

    private void update_nr_events() {
        this.nr_events = 1;
        this.nr_sources = 1;
        for (String string : this.m_placeholders.values()) {
            String string2;
            String[] stringArray = string.split("\\[");
            if (stringArray.length >= 2 && (string2 = stringArray[stringArray.length - 1]).endsWith("]")) {
                try {
                    int n = Integer.parseInt(string2.replace("]", "")) + 1;
                    if (n > this.nr_events) {
                        this.nr_events = n;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((stringArray = string.split("#")).length < 2) continue;
            try {
                int n = Integer.parseInt(stringArray[0]);
                if (++n <= this.nr_sources) continue;
                this.nr_sources = n;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        ++this.nr_events;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.m_properties.get(XML_TITLE);
    }

    public String getIsDefault() {
        return this.m_properties.get(XML_DEFAULT);
    }
}

