/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates;

import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.displays.Display;
import de.wilke.wizepanel.templates.TemplateInfo;
import de.wilke.wizepanel.templates.TemplateManagerListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.json.JSONException;
import org.json.JSONObject;

public class TemplateManager {
    private long last_update = 0L;
    private final List<String> templates = new LinkedList<String>();
    private final Map<String, TemplateInfo> info_cache = new HashMap<String, TemplateInfo>();
    private final boolean load_from_disc;
    private final Set<TemplateManagerListener> change_listeners = new HashSet<TemplateManagerListener>();

    public TemplateManager(boolean bl) {
        this.load_from_disc = bl;
    }

    public synchronized void setTemplates(String[] stringArray) {
        this.info_cache.clear();
        this.templates.clear();
        for (String string : stringArray) {
            this.templates.add(string);
        }
        this.last_update = System.currentTimeMillis();
        Collections.sort(this.templates);
        this.inform_change_listeners();
    }

    public synchronized void setTemplates(List<String> list) {
        this.info_cache.clear();
        this.templates.clear();
        for (String string : list) {
            this.templates.add(string);
        }
        this.last_update = System.currentTimeMillis();
        Collections.sort(this.templates);
        this.inform_change_listeners();
    }

    public synchronized void removeEntry(String string) {
        this.templates.remove(string);
        this.info_cache.remove(string);
        Collections.sort(this.templates);
        this.inform_change_listeners();
    }

    public synchronized void addEntry(String string) {
        this.templates.add(string);
        Collections.sort(this.templates);
        this.inform_change_listeners();
    }

    public synchronized void addEntry(String string, TemplateInfo templateInfo) {
        this.templates.add(string);
        this.info_cache.put(string, templateInfo);
        Collections.sort(this.templates);
        this.inform_change_listeners();
    }

    public synchronized void resetEntry(String string, TemplateInfo templateInfo) {
        if (this.templates.contains(string)) {
            if (templateInfo == null) {
                this.info_cache.remove(string);
            } else {
                this.info_cache.put(string, templateInfo);
            }
            this.inform_change_listeners();
        }
    }

    public long lastUpdate() {
        return this.last_update;
    }

    public void setLastUpdate(long l) {
        this.last_update = l;
    }

    public synchronized List<String> getTemplateList() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this.templates) {
            linkedList.add(string);
        }
        return linkedList;
    }

    public synchronized List<TemplateInfo> getTemplateInfoList() {
        LinkedList<TemplateInfo> linkedList = new LinkedList<TemplateInfo>();
        for (String string : this.templates) {
            try {
                linkedList.add(new TemplateInfo(string, this.getInfo(string).toJSON()));
            }
            catch (Exception exception) {}
        }
        return linkedList;
    }

    public synchronized List<String> getTemplateList(Display display) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this.templates) {
            TemplateInfo templateInfo = this.getInfo(string);
            if (templateInfo == null || display.getType() != Display.Type.TYPE_CUSTOM && !templateInfo.display().isSupportedSize(display.getWidth(), display.getHeight())) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    public synchronized TemplateInfo getInfo(String string) {
        if (this.info_cache.containsKey(string)) {
            return this.info_cache.get(string);
        }
        TemplateInfo templateInfo = null;
        if (this.load_from_disc) {
            try {
                WpFile wpFile = new WpFile(string, WpFile.WpFileType.TEMPLATE_FILE);
                templateInfo = new TemplateInfo(wpFile.getResolvedFileName());
                this.inform_change_listeners();
            }
            catch (Exception exception) {
                LogManager.getLogger(TemplateManager.class).error("Oops(" + string + ")", (Throwable)exception);
            }
        }
        this.info_cache.put(string, templateInfo);
        return templateInfo;
    }

    public synchronized JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string : this.templates) {
            TemplateInfo templateInfo = this.getInfo(string);
            if (templateInfo == null) continue;
            jSONObject.put(string, (Object)templateInfo.toJSON());
        }
        return jSONObject;
    }

    public synchronized void fromJSON(JSONObject jSONObject) throws Exception {
        this.info_cache.clear();
        this.templates.clear();
        for (String string : JSONObject.getNames((JSONObject)jSONObject)) {
            this.templates.add(string);
            this.info_cache.put(string, new TemplateInfo(string, jSONObject.getJSONObject(string)));
        }
        Collections.sort(this.templates);
        this.inform_change_listeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(TemplateManagerListener templateManagerListener) {
        Set<TemplateManagerListener> set = this.change_listeners;
        synchronized (set) {
            this.change_listeners.add(templateManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(TemplateManagerListener templateManagerListener) {
        Set<TemplateManagerListener> set = this.change_listeners;
        synchronized (set) {
            this.change_listeners.remove(templateManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inform_change_listeners() {
        Set<TemplateManagerListener> set = this.change_listeners;
        synchronized (set) {
            for (TemplateManagerListener templateManagerListener : this.change_listeners) {
                templateManagerListener.templateManagerModified();
            }
        }
    }
}

