/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates.elements;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.app.WP;
import de.wilke.wizepanel.templates.MouseHandle;
import de.wilke.wizepanel.templates.Template;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.LinkedList;

public abstract class TemplateElement {
    protected final Template _tpl;
    private String m_name = null;
    private int m_layer = 0;
    protected MouseHandle[] _handles = null;
    protected boolean m_resizable = true;
    private boolean m_moveable = true;
    protected String _placeholder = "";
    protected String _placeholder_format = "";
    private boolean _placeholder_show_default_if_empty = false;
    protected boolean _placeholder_hide_if_empty = false;
    protected Color _sys_fg = Color.BLUE;
    private boolean m_sys_border = false;
    protected static final BasicStroke SYS_BORDER_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f, 2.0f, 4.0f, 2.0f}, 0.0f);
    public static final String ELEM_MOVEABLE = "moveable";
    public static final String ELEM_NAME = "name";
    public static final String ELEM_PLACEHOLDER = "placeholder";
    public static final String ELEM_PLACEHOLDER_FORMAT = "placeholder_format";
    public static final String ELEM_PLACEHOLDER_SHOW_DEFAULT_IF_EMPTY = "placeholder_ignore_if_empty";
    public static final String ELEM_PLACEHOLDER_HIDE_IF_EMPTY = "placeholder_hide_if_empty";
    public static final String ELEM_TYPE = "type";
    public static final String ELEM_LAYER = "layer";
    public static final String ATTR_IMAGE_NAME = "attr.image_name";
    public static final String ATTR_FIT_TO_RECT = "attr.fit_to_rect";
    public static final String ATTR_KEEP_RATIO = "attr.keep_ratio";
    public static final String ATTR_TEXT = "attr.text";
    public static final String ATTR_FONT = "attr.font";
    public static final String ATTR_FILL_COLOR = "attr.fill_color";
    public static final String ATTR_TEXT_COLOR = "attr.text_color";
    public static final String ATTR_TEXT_PADDING_LEFT = "attr.text_padding_left";
    public static final String ATTR_TEXT_PADDING_TOP = "attr.text_padding_top";
    public static final String ATTR_TEXT_PADDING_RIGHT = "attr.text_padding_right";
    public static final String ATTR_TEXT_PADDING_BOTTOM = "attr.text_padding_bottom";
    public static final String ATTR_X = "attr.x";
    public static final String ATTR_Y = "attr.y";
    public static final String ATTR_W = "attr.w";
    public static final String ATTR_H = "attr.h";
    public static final String ATTR_X1 = "attr.x1";
    public static final String ATTR_Y1 = "attr.y1";
    public static final String ATTR_X2 = "attr.x2";
    public static final String ATTR_Y2 = "attr.y2";
    public static final String ATTR_LINE_WIDTH = "attr.line_width";
    public static final String ATTR_LINE_DASHES = "attr.line_dash";
    public static final String ATTR_LINE_CLOSE = "attr.line_close";
    public static final String ATTR_LINE_COLOR = "attr.line_color";
    public static final String ATTR_CORNER_RADIUS = "attr.corner_radius";
    public static final String ATTR_RESIZABLE = "attr.resizable";
    public static final String ATTR_HOR_ALIGN = "attr.hor_align";
    public static final String ATTR_VER_ALIGN = "attr.ver_align";
    public static final String ATTR_TRIM_TEXT = "attr.trim_text";
    public static final String ATTR_WRAP_TEXT = "attr.break_text";
    public static final String ATTR_FILTER_CHARS = "attr.filter_chars";
    public static final String ATTR_FILL_BG = "attr.fill_bg";
    public static final String ATTR_COLOR = "attr.color";
    public static final String ATTR_PROGRESS = "attr.progress";
    public static final String ATTR_EVENTS_DATA = "attr.events_data";
    public static final String ATTR_EVENT_JSON = "attr.event_json";
    public static final String ATTR_TIME_FONT = "attr.time.font";
    public static final String ATTR_TIME_HOR_ALIGN = "attr.time.hor_align";
    public static final String ATTR_TIME_FORMAT = "attr.time.format";
    public static final String ATTR_TIME_FONT_COLOR = "attr.time.font_color";
    public static final String ATTR_TIME_BACKGROUND = "attr.time.background";
    public static final String ATTR_TIME_FILL_BG = "attr.time.fill_bg";
    public static final String ATTR_TIME_W = "attr.time.w";
    public static final String ATTR_TIME_START = "attr.time.start";
    public static final String ATTR_TIME_END = "attr.time.end";
    public static final String ATTR_TIME_INTERVAL = "attr.time.interval";
    public static final String ATTR_TIME_PADDING = "attr.time.padding";
    public static final String ATTR_TIME_HALFHOURMARK = "attr.time.half_hour_mark";
    public static final String ATTR_TIME_IND_LINE_COLOR = "attr.time.indicator_line_color";
    public static final String ATTR_TIME_IND_LINE_WIDTH = "attr.time.indicator_line_w";
    public static final String ATTR_EVENT_HOR_ALIGN = "attr.event.hor_align";
    public static final String ATTR_EVENT_VER_ALIGN = "attr.event.ver_align";
    public static final String ATTR_EVENT_FONT = "attr.event.font";
    public static final String ATTR_EVENT_FONT_COLOR_CURRENT_DAY = "attr.event.font_color_current_day";
    public static final String ATTR_EVENT_FONT_COLOR_NONCURRENT_DAY = "attr.event.font_color_noncurrent_day";
    public static final String ATTR_EVENT_TIME_SHOW = "attr.event.time_show";
    public static final String ATTR_EVENT_TIME_BOLD = "attr.event.time_bold";
    public static final String ATTR_EVENT_SUMMARY_BOLD = "attr.event.summary_bold";
    public static final String ATTR_EVENT_DESC_BOLD = "attr.event.desc_bold";
    public static final String ATTR_EVENT_CURRENT_DAY_COLOR = "attr.event.current_day_color";
    public static final String ATTR_EVENT_NONCURRENT_DAY_COLOR = "attr.event.noncurrent_day_color";
    private static final Cursor cursor_forbidden = WP.getCursor("forbidden", new Point(12, 12));

    public TemplateElement(Template template) {
        this._tpl = template;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String name() {
        return this.m_name;
    }

    public boolean isValid() {
        return this.m_name != null;
    }

    public int layer() {
        return this.m_layer;
    }

    public void setLayer(int n) {
        this.m_layer = n;
    }

    public void setResizable(boolean bl) {
        this.m_resizable = bl;
        for (int i = 0; i < this._handles.length; ++i) {
            if (this.m_resizable) {
                this._handles[i].restoreCursor();
                continue;
            }
            this._handles[i].setCursor(cursor_forbidden);
        }
    }

    public void setMoveable(boolean bl) {
        this.m_moveable = bl;
        for (int i = 0; i < this._handles.length; ++i) {
            if (this.m_moveable) {
                this._handles[i].restoreCursor();
                continue;
            }
            this._handles[i].setCursor(cursor_forbidden);
        }
    }

    public boolean isMoveable() {
        return this.m_moveable;
    }

    public void setHelpBorder(boolean bl) {
        this.m_sys_border = bl;
    }

    public void setPlaceholderName(String string) {
        this._placeholder = string;
    }

    public final String getPlaceholderName() {
        return this._placeholder;
    }

    public void setPlaceholderValue(String string) {
    }

    public String getPlaceholderValue() {
        return "";
    }

    public String getPlaceholderFormat() {
        return this._placeholder_format;
    }

    public void setPlaceholderFormat(String string) {
        this._placeholder_format = string;
    }

    public boolean isPlaceholderShowDefaultIfEmpty() {
        return this._placeholder_show_default_if_empty;
    }

    public abstract boolean doHideElement();

    public abstract String type();

    public abstract void rebuild();

    public boolean canCopyAttributes() {
        return false;
    }

    public String[] attributesToCopy() {
        return null;
    }

    public boolean setAttribute(String string, String string2) {
        if (string.equalsIgnoreCase(ELEM_NAME)) {
            this.m_name = string2;
            return true;
        }
        if (string.equalsIgnoreCase(ELEM_TYPE)) {
            return true;
        }
        if (string.equalsIgnoreCase(ELEM_LAYER)) {
            this.m_layer = Integer.parseInt(string2);
            return true;
        }
        if (string.equalsIgnoreCase(ELEM_MOVEABLE)) {
            this.setMoveable(WpUtils.str2bool(string2));
            return true;
        }
        if (string.equalsIgnoreCase(ELEM_PLACEHOLDER)) {
            this.setPlaceholderName(string2);
            return true;
        }
        if (string.equalsIgnoreCase(ELEM_PLACEHOLDER_FORMAT)) {
            this._placeholder_format = string2;
            return true;
        }
        if (string.equalsIgnoreCase(ELEM_PLACEHOLDER_SHOW_DEFAULT_IF_EMPTY)) {
            this._placeholder_show_default_if_empty = WpUtils.str2bool(string2);
            return true;
        }
        if (string.equalsIgnoreCase(ELEM_PLACEHOLDER_HIDE_IF_EMPTY)) {
            this._placeholder_hide_if_empty = WpUtils.str2bool(string2);
            return true;
        }
        return false;
    }

    public String getAttribute(String string) {
        if (string.equalsIgnoreCase(ELEM_NAME)) {
            return this.m_name;
        }
        if (string.equalsIgnoreCase(ELEM_TYPE)) {
            return this.type();
        }
        if (string.equalsIgnoreCase(ELEM_LAYER)) {
            return Integer.toString(this.m_layer);
        }
        if (string.equalsIgnoreCase(ELEM_MOVEABLE)) {
            return WpUtils.bool2str(this.m_moveable);
        }
        if (string.equalsIgnoreCase(ELEM_PLACEHOLDER)) {
            return this._placeholder;
        }
        if (string.equalsIgnoreCase(ELEM_PLACEHOLDER_FORMAT)) {
            return this._placeholder_format;
        }
        if (string.equalsIgnoreCase(ELEM_PLACEHOLDER_SHOW_DEFAULT_IF_EMPTY)) {
            return WpUtils.bool2str(this._placeholder_show_default_if_empty);
        }
        if (string.equalsIgnoreCase(ELEM_PLACEHOLDER_HIDE_IF_EMPTY)) {
            return WpUtils.bool2str(this._placeholder_hide_if_empty);
        }
        return null;
    }

    public final HashMap<String, String> attributes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(ELEM_NAME, this.m_name);
        hashMap.put(ELEM_TYPE, this.type());
        hashMap.put(ELEM_LAYER, Integer.toString(this.m_layer));
        hashMap.put(ELEM_MOVEABLE, WpUtils.bool2str(this.m_moveable));
        hashMap.put(ELEM_PLACEHOLDER, this._placeholder);
        hashMap.put(ELEM_PLACEHOLDER_FORMAT, this._placeholder_format);
        hashMap.put(ELEM_PLACEHOLDER_SHOW_DEFAULT_IF_EMPTY, WpUtils.bool2str(this._placeholder_show_default_if_empty));
        hashMap.put(ELEM_PLACEHOLDER_HIDE_IF_EMPTY, WpUtils.bool2str(this._placeholder_hide_if_empty));
        for (String string : this.getAttributeNames()) {
            String string2 = this.getAttribute(string);
            if (string2 == null) {
                System.err.println("TemplateElement.attributes(name=" + this.m_name + ") unknown attribute " + string + ".");
                continue;
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    protected abstract LinkedList<String> getAttributeNames();

    public abstract void setPosition(int var1, int var2);

    public abstract void setSize(int var1, int var2);

    public abstract boolean isValidSize();

    public final void shift(int n, int n2) {
        int n3 = this.getX() + n;
        int n4 = this.getY() + n2;
        this.setPosition(n3, n4);
    }

    public abstract int getX();

    public abstract int getY();

    public abstract int getWidth();

    public abstract int getHeight();

    public final void draw(Graphics2D graphics2D, boolean bl, boolean bl2) {
        this.drawComponent(graphics2D);
        if (this.m_sys_border) {
            this.draw_sys_border(graphics2D);
        } else if (bl2) {
            this.drawHelpers(graphics2D);
        }
    }

    public MouseHandle getHandle(int n) {
        if (this._handles != null && n < this._handles.length) {
            return this._handles[n];
        }
        return null;
    }

    public final MouseHandle findHandle(Point point) {
        if (this._handles == null) {
            return null;
        }
        for (int i = 0; i < this._handles.length; ++i) {
            if (!this._handles[i].contains(point)) continue;
            return this._handles[i];
        }
        return null;
    }

    public void drawHandles(Graphics2D graphics2D, float f, Color color) {
        if (this._handles == null) {
            return;
        }
        for (int i = 0; i < this._handles.length; ++i) {
            this._handles[i].draw(graphics2D, f, color);
        }
    }

    public abstract MouseHandle getAnchorHandle();

    protected abstract void drawComponent(Graphics2D var1);

    protected void drawHelpers(Graphics2D graphics2D) {
    }

    public void setHandle(MouseHandle mouseHandle, int n, int n2, boolean bl) {
        if (this._handles != null) {
            for (int i = 0; i < this._handles.length; ++i) {
                if (this._handles[i] != mouseHandle) continue;
                this.setHandle(i, n, n2, bl);
                return;
            }
        }
    }

    protected abstract void setHandle(int var1, int var2, int var3, boolean var4);

    public abstract boolean intersects(Rectangle var1);

    public void normalize() {
    }

    protected final void draw_sys_border(Graphics2D graphics2D) {
        graphics2D.setColor(this._sys_fg);
        graphics2D.setStroke(SYS_BORDER_STROKE);
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        graphics2D.drawRect(n, n2, n3, n4);
    }
}

