/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates.elements;

import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.templates.Template;
import de.wilke.wizepanel.templates.elements.TemplateElementLineBase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.LinkedList;

public class TemplateElementLine
extends TemplateElementLineBase {
    private Line2D.Double m_line = new Line2D.Double(100.0, 100.0, 300.0, 200.0);
    private int m_line_width = 1;
    private int m_line_close = 0;
    private float[] m_line_dashes = null;
    private static final String LINECLOSE_ROUND = "lineclose.round";
    private static final String LINECLOSE_BUTT = "lineclose.butt";

    public TemplateElementLine(Template template) {
        super(template);
        this.rebuild();
    }

    @Override
    protected void drawComponent(Graphics2D graphics2D) {
        if (this.m_line_dashes != null) {
            graphics2D.setStroke(new BasicStroke(this.m_line_width, this.m_line_close, 0, 1.0f, this.m_line_dashes, 0.0f));
        } else {
            graphics2D.setStroke(new BasicStroke(this.m_line_width, this.m_line_close, 0));
        }
        graphics2D.setPaint(this.m_color);
        graphics2D.draw(this.m_line);
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        Rectangle rectangle2 = rectangle;
        if (this.m_line_width > 2) {
            rectangle2 = new Rectangle(rectangle);
            rectangle2.x -= this.m_line_width / 2;
            rectangle2.y -= this.m_line_width / 2;
            rectangle2.width += this.m_line_width / 2;
            rectangle2.height += this.m_line_width / 2;
        }
        return this.m_line.intersects(rectangle2);
    }

    @Override
    public void rebuild() {
        this.m_line.setLine(this.m_x1, this.m_y1, this.m_x2, this.m_y2);
    }

    public float[] getLineDashes() {
        return this.m_line_dashes;
    }

    public int getLineWidth() {
        return this.m_line_width;
    }

    public Color getLineColor() {
        return this.m_color;
    }

    private String lineclose2str(int n) {
        if (n == 1) {
            return LINECLOSE_ROUND;
        }
        return LINECLOSE_BUTT;
    }

    private int str2lineclose(String string) {
        if (string.equals(LINECLOSE_ROUND)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean setAttribute(String string, String string2) {
        if (string.equals("attr.line_width")) {
            this.m_line_width = Integer.parseInt(string2);
            return true;
        }
        if (string.equals("attr.line_close")) {
            this.m_line_close = this.str2lineclose(string2);
            return true;
        }
        if (string.equals("attr.line_dash")) {
            this.m_line_dashes = WpTemplateUtils.str2linedashes(string2);
            return true;
        }
        if (string.equals("attr.line_color")) {
            this.m_color = WpTemplateUtils.str2color(string2);
            return true;
        }
        return super.setAttribute(string, string2);
    }

    @Override
    public String getAttribute(String string) {
        if (string.equals("attr.line_width")) {
            return Integer.toString(this.m_line_width);
        }
        if (string.equals("attr.line_close")) {
            return this.lineclose2str(this.m_line_close);
        }
        if (string.equals("attr.line_dash")) {
            return WpTemplateUtils.linedashes2str(this.m_line_dashes);
        }
        if (string.equals("attr.line_color")) {
            return WpTemplateUtils.color2str(this.m_color);
        }
        return super.getAttribute(string);
    }

    @Override
    protected LinkedList<String> getAttributeNames() {
        LinkedList<String> linkedList = super.getAttributeNames();
        linkedList.add("attr.line_width");
        linkedList.add("attr.line_close");
        linkedList.add("attr.line_dash");
        linkedList.add("attr.line_color");
        return linkedList;
    }

    @Override
    public String type() {
        return "tool.line";
    }

    @Override
    public boolean doHideElement() {
        return false;
    }
}

