/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates.elements;

import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.templates.Template;
import de.wilke.wizepanel.templates.elements.TemplateElementRectBase;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.LinkedList;

public class TemplateElementRect
extends TemplateElementRectBase {
    private Rectangle2D.Double m_rect = new Rectangle2D.Double();
    private RoundRectangle2D.Double m_round_rect = new RoundRectangle2D.Double();
    private int m_line_width = 1;
    private int m_cornerradius = 0;
    private float[] m_line_dashes = null;

    public TemplateElementRect(Template template) {
        super(template);
        this.rebuild();
    }

    @Override
    protected void drawComponent(Graphics2D graphics2D) {
        if (this.m_fill_bg) {
            graphics2D.setPaint(this.m_fill_color);
            RectangularShape rectangularShape = null;
            rectangularShape = this.m_cornerradius == 0 ? this.m_rect : this.m_round_rect;
            graphics2D.fill(rectangularShape);
        }
        if (this.m_line_width > 0) {
            if (this.m_line_dashes != null) {
                graphics2D.setStroke(new BasicStroke(this.m_line_width, 0, 0, 1.0f, this.m_line_dashes, 0.0f));
            } else {
                graphics2D.setStroke(new BasicStroke(this.m_line_width));
            }
            graphics2D.setPaint(this.m_border_color);
            if (this.m_cornerradius == 0) {
                graphics2D.draw(this.m_rect);
            } else {
                graphics2D.draw(this.m_round_rect);
            }
        }
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        return this.m_rect.intersects(rectangle);
    }

    @Override
    public void rebuild() {
        double d = this.getX();
        double d2 = this.getY();
        double d3 = this.getX() + this.getWidth();
        double d4 = this.getY() + this.getHeight();
        double d5 = Math.min(d, d3);
        double d6 = Math.min(d2, d4);
        double d7 = Math.abs(d - d3);
        double d8 = Math.abs(d2 - d4);
        this.m_rect.setRect(d5, d6, d7, d8);
        this.m_round_rect.setRoundRect(d5, d6, d7, d8, this.m_cornerradius, this.m_cornerradius);
    }

    public int getCornerRadius() {
        return this.m_cornerradius;
    }

    public float[] getLineDashes() {
        return this.m_line_dashes;
    }

    public int getLineWidth() {
        return this.m_line_width;
    }

    @Override
    public String type() {
        return "tool.rect";
    }

    @Override
    public boolean setAttribute(String string, String string2) {
        if (string.equals("attr.corner_radius")) {
            this.m_cornerradius = Integer.parseInt(string2);
            if (this.m_cornerradius < 0) {
                this.m_cornerradius = 0;
            }
            this.rebuild();
            return true;
        }
        if (string.equals("attr.line_width")) {
            this.m_line_width = Integer.parseInt(string2);
            return true;
        }
        if (string.equals("attr.line_dash")) {
            this.m_line_dashes = WpTemplateUtils.str2linedashes(string2);
            return true;
        }
        return super.setAttribute(string, string2);
    }

    @Override
    public String getAttribute(String string) {
        if (string.equals("attr.corner_radius")) {
            return Integer.toString(this.m_cornerradius);
        }
        if (string.equals("attr.line_width")) {
            return Integer.toString(this.m_line_width);
        }
        if (string.equals("attr.line_dash")) {
            return WpTemplateUtils.linedashes2str(this.m_line_dashes);
        }
        return super.getAttribute(string);
    }

    @Override
    protected LinkedList<String> getAttributeNames() {
        LinkedList<String> linkedList = super.getAttributeNames();
        linkedList.add("attr.corner_radius");
        linkedList.add("attr.line_width");
        linkedList.add("attr.line_dash");
        return linkedList;
    }

    @Override
    public boolean doHideElement() {
        return false;
    }
}

