/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates.format;

import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.templates.format.PlaceholderFormatter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

class DateTimeFormatter
extends PlaceholderFormatter {
    private Date date1 = null;
    private Date date2 = null;

    public DateTimeFormatter() {
        super("date");
    }

    @Override
    protected String format(String string, TimeZone timeZone, int n) {
        Locale locale;
        String string2 = WpSystemLocator.getLocator().getDateTimeLocale();
        if (string2 != null && string2 != "") {
            try {
                locale = new Locale(string2);
            }
            catch (Exception exception) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        if (n == 1 && this.date2 != null) {
            return simpleDateFormat.format(this.date2);
        }
        return simpleDateFormat.format(this.date1);
    }

    @Override
    protected String legacy_format(String string, TimeZone timeZone) {
        if (!string.startsWith(this.type + ":")) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string.substring(this.type.length() + 1));
            if (timeZone != null) {
                simpleDateFormat.setTimeZone(timeZone);
            }
            return simpleDateFormat.format(this.date1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    protected boolean set_data(String string) {
        String[] stringArray = string.split(" ");
        this.date1 = WpTimeUtils.str2date(stringArray[0]);
        if (stringArray.length == 2) {
            this.date2 = WpTimeUtils.str2date(stringArray[1]);
        }
        return this.date1 != null;
    }
}

