/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.client;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.upi.client.IUpiClientRequestStrategy;
import de.wilke.wizepanel.upi.client.WpUpiClientRequestJava;
import de.wilke.wizepanel.upi.client.WpUpiClientRequestStatus;
import de.wilke.wizepanel.upi.client.WpUpiRequest;
import java.io.IOException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class WpUpiClient {
    private String serverAddr = "";
    private IUpiClientRequestStrategy requestStrategy = new WpUpiClientRequestJava();
    private WpUpiRequest.UpiMethod method = null;
    private String path = null;
    private String params_string = null;
    private Map<String, String> params_map = null;

    public WpUpiClient() {
    }

    public WpUpiClient(String string, int n) {
        this("http://" + string + ":" + n);
    }

    public WpUpiClient(String string) {
        this();
        this.serverAddr = string;
    }

    public WpUpiClientRequestStatus request(String string, String string2, Map<String, String> map) throws IOException {
        switch (WpUpiRequest.UpiMethod.fromString(string2)) {
            case GET: {
                return this.requestGet(string, map);
            }
            case PUT: {
                return this.requestPut(string, map);
            }
        }
        return new WpUpiClientRequestStatus(string2 + " " + string, WpUpiClientRequestStatus.UpiRequestStatus.INTERNAL_SERVER_ERROR.toInt(), WizePanelExceptions.ErrorCodes.WP_SERV_UNKNOWN_METHOD.name(), "");
    }

    public WpUpiClientRequestStatus requestGet(String string, Map<String, String> map) throws IOException {
        String string2 = this.serverAddr + "/" + string;
        if (null != map && !map.isEmpty()) {
            int n = 0;
            string2 = string2 + "?";
            for (Map.Entry<String, String> entry : map.entrySet()) {
                string2 = string2 + entry.getKey() + "=" + entry.getValue() + (n > 0 ? "&" : "");
                ++n;
            }
        }
        WpUpiRequest wpUpiRequest = new WpUpiRequest(WpUpiRequest.UpiMethod.GET, string2);
        return this.processRequest(wpUpiRequest);
    }

    public WpUpiClientRequestStatus requestPut(String string, String string2) throws IOException {
        WpUpiRequest wpUpiRequest = new WpUpiRequest(WpUpiRequest.UpiMethod.PUT, this.serverAddr + "/" + string).setParams(string2).setMediaType(WpUpiRequest.UpiMediaType.TEXT_PLAIN);
        return this.processRequest(wpUpiRequest);
    }

    public WpUpiClientRequestStatus requestPut(String string, JSONObject jSONObject) throws IOException {
        WpUpiRequest wpUpiRequest = new WpUpiRequest(WpUpiRequest.UpiMethod.PUT, this.serverAddr + "/" + string).setParams(jSONObject.toString()).setMediaType(WpUpiRequest.UpiMediaType.APPLICATION_JSON);
        return this.processRequest(wpUpiRequest);
    }

    public WpUpiClientRequestStatus requestPut(String string, Map<String, String> map) throws IOException {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            try {
                jSONObject.put(entry.getKey(), (Object)entry.getValue());
            }
            catch (JSONException jSONException) {}
        }
        return this.requestPut(string, jSONObject);
    }

    private WpUpiClientRequestStatus processRequest(WpUpiRequest wpUpiRequest) throws IOException {
        if (null != this.requestStrategy && null != wpUpiRequest) {
            return this.requestStrategy.processRequest(wpUpiRequest);
        }
        return new WpUpiClientRequestStatus(wpUpiRequest.getMethod().toString() + " " + wpUpiRequest.getUri(), WpUpiClientRequestStatus.UpiRequestStatus.INTERNAL_SERVER_ERROR.toInt(), WizePanelExceptions.ErrorCodes.WP_SERV_UNKNOWN_METHOD.name(), "");
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public WpUpiClient setServerAddr(String string) {
        this.serverAddr = string;
        return this;
    }

    public IUpiClientRequestStrategy getRequestStrategy() {
        return this.requestStrategy;
    }

    public WpUpiClient setRequestStrategy(IUpiClientRequestStrategy iUpiClientRequestStrategy) {
        this.requestStrategy = iUpiClientRequestStrategy;
        return this;
    }

    protected void setMethod(WpUpiRequest.UpiMethod upiMethod) {
        this.method = upiMethod;
    }

    public WpUpiRequest.UpiMethod method() {
        return this.method;
    }

    protected void setPath(String string) {
        this.path = string;
    }

    public String path() {
        return this.path;
    }

    protected void setParams(Map<String, String> map) {
        this.params_map = map;
    }

    protected void setParams(String string) {
        this.params_string = string;
    }

    public String params() {
        if (this.params_string != null) {
            return this.params_string;
        }
        if (this.params_map != null) {
            JSONObject jSONObject = new JSONObject();
            for (Map.Entry<String, String> entry : this.params_map.entrySet()) {
                try {
                    jSONObject.put(entry.getKey(), (Object)entry.getValue());
                }
                catch (JSONException jSONException) {}
            }
            return jSONObject.toString();
        }
        return null;
    }

    public WpUpiClientRequestStatus exec() throws IOException {
        switch (this.method) {
            case GET: {
                return this.requestGet(this.path, this.params_map);
            }
            case PUT: {
                if (this.params_string != null) {
                    return this.requestPut(this.path, this.params_string);
                }
                return this.requestPut(this.path, this.params_map);
            }
        }
        return null;
    }
}

