/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.client;

import de.wilke.wizepanel.upi.client.IUpiClientRequestStrategy;
import de.wilke.wizepanel.upi.client.WpUpiClientRequestStatus;
import de.wilke.wizepanel.upi.client.WpUpiRequest;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.representation.Representation;

class WpUpiClientRequestRestlet
implements IUpiClientRequestStrategy {
    @Override
    public WpUpiClientRequestStatus processRequest(WpUpiRequest wpUpiRequest) {
        Client client = new Client(Protocol.HTTP);
        Request request = this.buildRestletRequest(wpUpiRequest);
        Response response = null;
        Representation representation = null;
        Status status = null;
        String string = null;
        response = client.handle(request);
        status = response.getStatus();
        representation = response.getEntity();
        if (null != representation) {
            StringWriter stringWriter = new StringWriter();
            try {
                representation.write((Writer)stringWriter);
                string = stringWriter.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new WpUpiClientRequestStatus(wpUpiRequest.getMethod().toString() + " " + wpUpiRequest.getUri(), status.getCode(), status.getDescription(), string);
    }

    private Request buildRestletRequest(WpUpiRequest wpUpiRequest) {
        if (null == wpUpiRequest) {
            return null;
        }
        Request request = new Request(this.getRequestMethod(wpUpiRequest.getMethod()), wpUpiRequest.getUri());
        if (null != wpUpiRequest.getParams() && !wpUpiRequest.getParams().isEmpty()) {
            request.setEntity(wpUpiRequest.getParams(), this.getRequestMediaType(wpUpiRequest.getMediaType()));
        }
        return request;
    }

    private Method getRequestMethod(WpUpiRequest.UpiMethod upiMethod) {
        switch (upiMethod) {
            case GET: {
                return Method.GET;
            }
            case PUT: {
                return Method.PUT;
            }
            case POST: {
                return Method.POST;
            }
            case DELETE: {
                return Method.DELETE;
            }
        }
        return Method.GET;
    }

    private MediaType getRequestMediaType(WpUpiRequest.UpiMediaType upiMediaType) {
        switch (upiMediaType) {
            case TEXT_PLAIN: {
                return MediaType.TEXT_PLAIN;
            }
            case APPLICATION_JSON: {
                return MediaType.APPLICATION_JSON;
            }
        }
        return MediaType.TEXT_PLAIN;
    }
}

