/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.routing;

import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.locator.IWpLocatorPropertyType;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.upi.IUpiJsonable;
import de.wilke.wizepanel.upi.routing.RoutingTable;
import de.wilke.wizepanel.upi.routing.UpiRouterItem;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import de.wilke.wizepanel.upi.routing.old.UpiRouterItemV2;
import de.wilke.wizepanel.upi.routing.old.UpiRoutingHandlerV2;
import de.wilke.wizepanel.upi.routing.old.UpiServerItemV2;
import de.wilke.wizepanel.upi.routing.old.UpiTargetItemV2;
import de.wilke.wizepanel.upi.types.RouterParameters;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.json.JSONException;
import org.json.JSONObject;

@XmlRootElement(name="UpiRoutingV3")
public class UpiRoutingHandler
implements IUpiJsonable {
    private List<UpiRouterItem> routers = Collections.synchronizedList(new LinkedList());
    private String filename;
    private static final String OLD_ROUTING_TABLE_BACKUP_V2_EXT = ".v2.old";
    private static final JAXBContext jaxb_context = UpiRoutingHandler.initContext();

    public UpiRoutingHandler() {
    }

    private UpiRoutingHandler(String string) {
        this();
        this.filename = string;
        this.loadRoutingTable();
    }

    public List<UpiRouterItem> getRouters() {
        return this.routers;
    }

    public void addRouter(UpiRouterItem upiRouterItem) {
        this.routers.add(upiRouterItem);
        this.validate_targets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpiTargetItem getTargetByName(String string) {
        if (string == null) {
            return null;
        }
        List<UpiRouterItem> list = this.routers;
        synchronized (list) {
            for (UpiRouterItem upiRouterItem : this.routers) {
                for (UpiTargetItem upiTargetItem : upiRouterItem.getTargets()) {
                    if (!string.equals(upiTargetItem.getParams().getName())) continue;
                    return upiTargetItem;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpiTargetItem getTargetById(String string) {
        if (string == null) {
            return null;
        }
        List<UpiRouterItem> list = this.routers;
        synchronized (list) {
            for (UpiRouterItem upiRouterItem : this.routers) {
                UpiTargetItem upiTargetItem = upiRouterItem.getTargetById(string);
                if (upiTargetItem == null) continue;
                return upiTargetItem;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpiRouterItem getRouterByName(String string) {
        if (string == null) {
            return null;
        }
        List<UpiRouterItem> list = this.routers;
        synchronized (list) {
            for (UpiRouterItem upiRouterItem : this.routers) {
                if (upiRouterItem.getParams().getName() != string) continue;
                return upiRouterItem;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpiRouterItem getRouterByTargetId(String string) {
        if (string == null) {
            return null;
        }
        List<UpiRouterItem> list = this.routers;
        synchronized (list) {
            for (UpiRouterItem upiRouterItem : this.routers) {
                if (upiRouterItem.getTargetById(string) == null) continue;
                return upiRouterItem;
            }
        }
        return null;
    }

    private void loadRoutingTable() {
        this.routers.clear();
        if (this.filename == null) {
            return;
        }
        try {
            Unmarshaller unmarshaller = jaxb_context.createUnmarshaller();
            UpiRoutingHandler upiRoutingHandler = (UpiRoutingHandler)unmarshaller.unmarshal(new File(this.filename));
            this.routers = Collections.synchronizedList(upiRoutingHandler.getRouters());
        }
        catch (JAXBException jAXBException) {
            this.importOldRoutingTableV2();
            this.saveRoutingTable();
        }
        this.validate_targets();
    }

    private void importOldRoutingTableV2() {
        Object object2;
        this.routers.clear();
        UpiRoutingHandlerV2 upiRoutingHandlerV2 = new UpiRoutingHandlerV2(this.filename);
        for (Object object2 : upiRoutingHandlerV2.getServers()) {
            if (((UpiServerItemV2)object2).getPort() != 8182 && ((UpiServerItemV2)object2).getPort() != 0) continue;
            for (UpiRouterItemV2 upiRouterItemV2 : ((UpiServerItemV2)object2).getRouters()) {
                UpiRouterItem upiRouterItem = new UpiRouterItem(upiRouterItemV2.getId());
                upiRouterItem.getParams().importFrom(new RouterParameters(upiRouterItemV2.getRouterParams()));
                this.addRouter(upiRouterItem);
                for (UpiTargetItemV2 upiTargetItemV2 : upiRouterItemV2.getTargets()) {
                    UpiTargetItem upiTargetItem = new UpiTargetItem(upiTargetItemV2.getId());
                    upiTargetItem.getParams().setName(upiTargetItemV2.getName());
                    upiTargetItem.getParams().setType(upiTargetItemV2.getType());
                    upiTargetItem.getParams().setWakeup(upiTargetItemV2.getLatency());
                    upiRouterItem.addTarget(upiTargetItem);
                }
            }
        }
        this.validate_targets();
        File file = new File(this.filename);
        object2 = new File(this.filename + OLD_ROUTING_TABLE_BACKUP_V2_EXT);
        try {
            WpFileUtils.copyFile((File)file, (File)object2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveRoutingTable() {
        if (this.filename != null) {
            this.saveRoutingTableTo(this.filename);
        }
    }

    private static JAXBContext initContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{UpiRoutingHandler.class});
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            return null;
        }
    }

    private void saveRoutingTableTo(String string) {
        if (jaxb_context == null) {
            return;
        }
        try {
            Marshaller marshaller = jaxb_context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
                marshaller.marshal((Object)this, (OutputStream)fileOutputStream);
            }
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(UpiRoutingHandler upiRoutingHandler) {
        if (upiRoutingHandler.getRouters().size() != this.routers.size()) {
            return false;
        }
        List<UpiRouterItem> list = this.routers;
        synchronized (list) {
            for (UpiRouterItem upiRouterItem : this.routers) {
                UpiRouterItem upiRouterItem2 = upiRoutingHandler.getRouterById(upiRouterItem.getId());
                if (upiRouterItem2 == null) {
                    return false;
                }
                if (upiRouterItem2.getTargets().size() != upiRouterItem.getTargets().size()) {
                    return false;
                }
                for (UpiTargetItem upiTargetItem : upiRouterItem.getTargets()) {
                    UpiTargetItem upiTargetItem2 = upiRouterItem2.getTargetById(upiTargetItem.getId());
                    if (upiTargetItem2 != null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void fromJson(JSONObject jSONObject) {
        System.err.println("WpUpiRoutingHandler#fromJson() disabled.");
    }

    @Override
    public JSONObject toJson() throws JSONException {
        return this.toRoutingTable().toJSON();
    }

    public RoutingTable toRoutingTable() {
        RoutingTable routingTable = new RoutingTable();
        for (UpiRouterItem upiRouterItem : this.getRouters()) {
            routingTable.addRouter(upiRouterItem.getId());
            routingTable.setRouterParameter(upiRouterItem.getId(), upiRouterItem.getParams());
            for (UpiTargetItem upiTargetItem : upiRouterItem.getTargets()) {
                routingTable.addRouterTarget(upiRouterItem.getId(), upiTargetItem);
            }
        }
        return routingTable;
    }

    public void fromRoutingTable(RoutingTable routingTable) {
        this.routers.clear();
        if (routingTable.getRouters() == null) {
            return;
        }
        for (String string : routingTable.getRouters()) {
            UpiRouterItem upiRouterItem = new UpiRouterItem(string);
            upiRouterItem.getParams().importFrom(routingTable.getRouterParameters(string));
            this.addRouter(upiRouterItem);
            if (routingTable.getRouterTargets(string) == null) continue;
            for (String string2 : routingTable.getRouterTargets(string)) {
                UpiTargetItem upiTargetItem = new UpiTargetItem(string2);
                upiTargetItem.getParams().fullCopyFrom(routingTable.getRouterTargetParameters(string, string2));
                upiRouterItem.addTarget(upiTargetItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = "";
        List<UpiRouterItem> list = this.routers;
        synchronized (list) {
            for (UpiRouterItem upiRouterItem : this.routers) {
                object = (String)object + "    + " + upiRouterItem.getId() + " | " + upiRouterItem.getParams() + "\n";
                for (UpiTargetItem upiTargetItem : upiRouterItem.getTargets()) {
                    object = (String)object + "        + " + upiTargetItem.getId() + " (name: " + upiTargetItem.getParams() + ")\n";
                }
            }
        }
        return object;
    }

    @XmlElementWrapper(name="routerList")
    @XmlElement(name="router")
    public void setRouters(List<UpiRouterItem> list) {
        this.routers = Collections.synchronizedList(list);
    }

    public static UpiRoutingHandler getInstance() {
        return new UpiRoutingHandler(WpSystemLocator.getLocator().getProperty((IWpLocatorPropertyType)WpSystemLocator.WpSystemLocatorPropType.UPI_ROUTING_FILE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpiRouterItem getRouterById(String string) {
        if (string == null) {
            return null;
        }
        List<UpiRouterItem> list = this.routers;
        synchronized (list) {
            for (UpiRouterItem upiRouterItem : this.routers) {
                if (!upiRouterItem.getId().equals(string)) continue;
                return upiRouterItem;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRouter(String string) {
        List<UpiRouterItem> list = this.routers;
        synchronized (list) {
            Iterator<UpiRouterItem> iterator = this.routers.iterator();
            while (iterator.hasNext()) {
                UpiRouterItem upiRouterItem = iterator.next();
                if (!upiRouterItem.getId().equals(string)) continue;
                iterator.remove();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTargetById(String string) {
        List<UpiRouterItem> list = this.routers;
        synchronized (list) {
            for (UpiRouterItem upiRouterItem : this.routers) {
                Iterator<UpiTargetItem> iterator = upiRouterItem.getTargets().iterator();
                while (iterator.hasNext()) {
                    UpiTargetItem upiTargetItem = iterator.next();
                    if (!upiTargetItem.getId().equals(string)) continue;
                    iterator.remove();
                    return;
                }
            }
        }
    }

    private String make_name_unique(String string) {
        Object object = string;
        int n = 2;
        while (this.getTargetByName((String)object) != null) {
            object = string + "#" + n;
            ++n;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate_targets() {
        List<UpiRouterItem> list = this.routers;
        synchronized (list) {
            for (UpiRouterItem upiRouterItem : this.routers) {
                for (UpiTargetItem upiTargetItem : upiRouterItem.getTargets()) {
                    if (upiTargetItem.getParams().getName() == null || upiTargetItem.getParams().getName().isEmpty()) {
                        upiTargetItem.getParams().setName(this.make_name_unique(upiTargetItem.getId()));
                    }
                    if (upiTargetItem.getParams().getRequiredWakeup() != 0) continue;
                    upiTargetItem.getParams().setRequiredWakeup(upiTargetItem.getParams().getWakeup());
                }
            }
        }
    }
}

