/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.routing.old;

import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.locator.IWpLocatorPropertyType;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.upi.IUpiJsonable;
import de.wilke.wizepanel.upi.routing.jaxb.RouterType;
import de.wilke.wizepanel.upi.routing.jaxb.ServerType;
import de.wilke.wizepanel.upi.routing.jaxb.TargetType;
import de.wilke.wizepanel.upi.routing.jaxb.WpUpiRoutingType;
import de.wilke.wizepanel.upi.routing.old.AWpPersistWithJaxb;
import de.wilke.wizepanel.upi.routing.old.UpiRouterItemV2;
import de.wilke.wizepanel.upi.routing.old.UpiServerItemV2;
import de.wilke.wizepanel.upi.routing.old.UpiTargetItemV2;
import de.wilke.wizepanel.upi.routing.old.WpUpiRoutingJaxbProxy;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.json.JSONException;
import org.json.JSONObject;

@XmlRootElement(name="UpiRouting")
public class UpiRoutingHandlerV2<S extends UpiServerItemV2>
implements IUpiJsonable {
    private List<S> servers = new LinkedList<S>();
    private String routingStoragePath;
    private final Object read_write_lock = new Object();
    private static final String OLD_ROUTING_TABLE_BACKUP_V1_EXT = ".v1.old";
    private static final String OLD_ROUTING_TABLE_DUMMY_SERVER = "localhost";

    public UpiRoutingHandlerV2() {
        this.servers = new ArrayList<S>();
    }

    public UpiRoutingHandlerV2(String string) {
        this();
        this.routingStoragePath = string;
        this.loadRoutingTable();
    }

    public List<S> getServers() {
        return this.servers;
    }

    public S getServerById(String string) {
        for (UpiServerItemV2 upiServerItemV2 : this.servers) {
            if (!upiServerItemV2.getId().equals(string)) continue;
            return (S)upiServerItemV2;
        }
        return null;
    }

    public S getServerByIpAndPort(String string, int n) {
        for (UpiServerItemV2 upiServerItemV2 : this.servers) {
            if (!upiServerItemV2.getIp().equals(string) || upiServerItemV2.getPort() != n) continue;
            return (S)upiServerItemV2;
        }
        return null;
    }

    public S getServerByTargetName(String string) {
        for (UpiServerItemV2 upiServerItemV2 : this.servers) {
            for (UpiRouterItemV2 upiRouterItemV2 : upiServerItemV2.getRouters()) {
                for (UpiTargetItemV2 upiTargetItemV2 : upiRouterItemV2.getTargets()) {
                    if (!string.equals(upiTargetItemV2.getName())) continue;
                    return (S)upiServerItemV2;
                }
            }
        }
        return null;
    }

    public UpiTargetItemV2 getTargetByName(String string) {
        if (string == null) {
            return null;
        }
        for (UpiServerItemV2 upiServerItemV2 : this.servers) {
            for (UpiRouterItemV2 upiRouterItemV2 : upiServerItemV2.getRouters()) {
                for (UpiTargetItemV2 upiTargetItemV2 : upiRouterItemV2.getTargets()) {
                    if (!string.equals(upiTargetItemV2.getName())) continue;
                    return upiTargetItemV2;
                }
            }
        }
        return null;
    }

    public void addServer(S s) {
        this.servers.add(s);
    }

    public void removeServer(UpiServerItemV2 upiServerItemV2) {
        this.servers.remove(upiServerItemV2);
    }

    private void loadRoutingTable() {
        this.servers.clear();
        if (this.routingStoragePath == null) {
            return;
        }
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{UpiRoutingHandlerV2.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            UpiRoutingHandlerV2 upiRoutingHandlerV2 = (UpiRoutingHandlerV2)unmarshaller.unmarshal(new File(this.routingStoragePath));
            this.servers = upiRoutingHandlerV2.getServers();
        }
        catch (JAXBException jAXBException) {
            this.importOldRoutingTableV1();
            this.saveRoutingTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void importOldRoutingTableV1() {
        Object object = this.read_write_lock;
        synchronized (object) {
            WpUpiRoutingJaxbProxy wpUpiRoutingJaxbProxy = new WpUpiRoutingJaxbProxy(this.routingStoragePath);
            ((AWpPersistWithJaxb)wpUpiRoutingJaxbProxy).readItemFromFile();
            WpUpiRoutingType wpUpiRoutingType = (WpUpiRoutingType)((AWpPersistWithJaxb)wpUpiRoutingJaxbProxy).getRootValue();
            if (wpUpiRoutingType == null) {
                return;
            }
            if (wpUpiRoutingType.getServers() != null) {
                for (ServerType object32 : wpUpiRoutingType.getServers().getServer()) {
                    this.servers.add(new UpiServerItemV2(object32));
                }
            }
            HashMap hashMap = new HashMap();
            if (wpUpiRoutingType.getRouters() != null && !wpUpiRoutingType.getRouters().getRouter().isEmpty()) {
                Object var5_6 = null;
                if (this.servers.size() == 0) {
                    UpiServerItemV2 upiServerItemV2 = new UpiServerItemV2(OLD_ROUTING_TABLE_DUMMY_SERVER, "0", 0);
                    this.servers.add(upiServerItemV2);
                }
                for (RouterType routerType : wpUpiRoutingType.getRouters().getRouter()) {
                    S s = this.getServerById(routerType.getServerid());
                    if (s == null) {
                        void var5_8;
                        s = var5_8;
                    }
                    if (s != null) {
                        UpiRouterItemV2 upiRouterItemV2 = new UpiRouterItemV2(routerType);
                        ((UpiServerItemV2)s).addRouter(upiRouterItemV2);
                        hashMap.put(routerType.getId(), upiRouterItemV2);
                        continue;
                    }
                    System.out.println("WpUpiRoutingHandler#importOldRoutingTable(): Could not import router with ID '" + routerType.getId() + "'");
                }
            }
            if (wpUpiRoutingType.getTargets() != null) {
                for (TargetType targetType : wpUpiRoutingType.getTargets().getTarget()) {
                    UpiRouterItemV2 upiRouterItemV2 = (UpiRouterItemV2)hashMap.get(targetType.getRouterid());
                    if (upiRouterItemV2 != null) {
                        upiRouterItemV2.addTarget(new UpiTargetItemV2(targetType));
                        continue;
                    }
                    System.out.println("WpUpiRoutingHandler#importOldRoutingTable(): Could not import target with ID '" + targetType.getId() + "'");
                }
            }
            File file = new File(this.routingStoragePath);
            File file2 = new File(this.routingStoragePath + OLD_ROUTING_TABLE_BACKUP_V1_EXT);
            try {
                WpFileUtils.copyFile((File)file, (File)file2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void saveRoutingTable() {
        if (this.routingStoragePath != null) {
            this.saveRoutingTableTo(this.routingStoragePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRoutingTableTo(String string) {
        Object object = this.read_write_lock;
        synchronized (object) {
            try {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{UpiRoutingHandlerV2.class});
                Marshaller marshaller = jAXBContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                try (FileWriter fileWriter = new FileWriter(string);){
                    marshaller.marshal((Object)this, (Writer)fileWriter);
                }
            }
            catch (JAXBException jAXBException) {
                jAXBException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean equals(UpiRoutingHandlerV2<? extends UpiServerItemV2> upiRoutingHandlerV2) {
        if (upiRoutingHandlerV2.getServers().size() != this.servers.size()) {
            return false;
        }
        for (UpiServerItemV2 upiServerItemV2 : this.servers) {
            UpiServerItemV2 upiServerItemV22 = upiRoutingHandlerV2.getServerById(upiServerItemV2.getId());
            if (upiServerItemV22 == null) {
                return false;
            }
            if (upiServerItemV22.getRouters().size() != upiServerItemV2.getRouters().size()) {
                return false;
            }
            for (UpiRouterItemV2 upiRouterItemV2 : upiServerItemV2.getRouters()) {
                UpiRouterItemV2 upiRouterItemV22 = upiServerItemV22.getRouterById(upiRouterItemV2.getId());
                if (upiRouterItemV22 == null) {
                    return false;
                }
                if (upiRouterItemV22.getTargets().size() != upiRouterItemV2.getTargets().size()) {
                    return false;
                }
                for (UpiTargetItemV2 upiTargetItemV2 : upiRouterItemV2.getTargets()) {
                    UpiTargetItemV2 upiTargetItemV22 = upiRouterItemV22.getTargetById(upiTargetItemV2.getId());
                    if (upiTargetItemV22 != null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void fromJson(JSONObject jSONObject) {
        System.err.println("WpUpiRoutingHandler#fromJson() disabled.");
    }

    @Override
    public JSONObject toJson() throws JSONException {
        System.err.println("WpUpiRoutingHandler#toJson() disabled.");
        JSONObject jSONObject = new JSONObject();
        return jSONObject;
    }

    public String toString() {
        Object object = "";
        for (UpiServerItemV2 upiServerItemV2 : this.servers) {
            object = (String)object + upiServerItemV2.getId() + "\n";
            for (UpiRouterItemV2 upiRouterItemV2 : upiServerItemV2.getRouters()) {
                object = (String)object + "    + " + upiRouterItemV2.getId() + "\n";
                for (UpiTargetItemV2 upiTargetItemV2 : upiRouterItemV2.getTargets()) {
                    object = (String)object + "        + " + upiTargetItemV2.getId() + " (name: " + upiTargetItemV2.getName() + ")\n";
                }
            }
        }
        return object;
    }

    @XmlElementWrapper(name="serverList")
    @XmlElement(name="server")
    public void setServers(List<S> list) {
        this.servers = list;
    }

    public static <S extends UpiServerItemV2> UpiRoutingHandlerV2<S> getInstance() {
        return new UpiRoutingHandlerV2<S>(WpSystemLocator.getLocator().getProperty((IWpLocatorPropertyType)WpSystemLocator.WpSystemLocatorPropType.UPI_ROUTING_FILE));
    }

    public static <S extends UpiServerItemV2> UpiRoutingHandlerV2<S> getInstance(String string) {
        return new UpiRoutingHandlerV2<S>(string);
    }

    public void sort() {
        for (UpiServerItemV2 upiServerItemV2 : this.servers) {
            for (UpiRouterItemV2 upiRouterItemV2 : upiServerItemV2.getRouters()) {
                upiRouterItemV2.sort();
            }
        }
    }
}

